"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultState = void 0;
var _constants = require("../../../../../common/constants");
var _form_field = require("./form_field");
var _form_section = require("./form_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Takes in a transform configuration and returns the default state to populate the form.
// It supports overrides to apply a pre-existing configuration.
// The implementation of this function is the only one that's specifically required to define
// the features of the transform edit form. All other functions are generic and could be reused
// in the future for other forms.
const getDefaultState = config => ({
  formFields: {
    // top level attributes
    description: (0, _form_field.initializeFormField)('description', 'description', config),
    frequency: (0, _form_field.initializeFormField)('frequency', 'frequency', config, {
      defaultValue: _constants.DEFAULT_TRANSFORM_FREQUENCY,
      validator: 'frequencyValidator'
    }),
    // dest.*
    destinationIndex: (0, _form_field.initializeFormField)('destinationIndex', 'dest.index', config, {
      dependsOn: ['destinationIngestPipeline'],
      isOptional: false
    }),
    destinationIngestPipeline: (0, _form_field.initializeFormField)('destinationIngestPipeline', 'dest.pipeline', config, {
      dependsOn: ['destinationIndex'],
      isOptional: true
    }),
    // settings.*
    docsPerSecond: (0, _form_field.initializeFormField)('docsPerSecond', 'settings.docs_per_second', config, {
      isNullable: true,
      isOptional: true,
      validator: 'integerAboveZeroValidator',
      valueParser: 'nullableNumberParser'
    }),
    maxPageSearchSize: (0, _form_field.initializeFormField)('maxPageSearchSize', 'settings.max_page_search_size', config, {
      defaultValue: `${_constants.DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE}`,
      isNullable: true,
      isOptional: true,
      validator: 'transformSettingsPageSearchSizeValidator',
      valueParser: 'numberParser'
    }),
    numFailureRetries: (0, _form_field.initializeFormField)('numFailureRetries', 'settings.num_failure_retries', config, {
      defaultValue: undefined,
      isNullable: true,
      isOptional: true,
      validator: 'transformSettingsNumberOfRetriesValidator',
      valueParser: 'numberParser'
    }),
    // retention_policy.*
    retentionPolicyField: (0, _form_field.initializeFormField)('retentionPolicyField', 'retention_policy.time.field', config, {
      dependsOn: ['retentionPolicyMaxAge'],
      isNullable: false,
      isOptional: true,
      isOptionalInSection: false,
      section: 'retentionPolicy'
    }),
    retentionPolicyMaxAge: (0, _form_field.initializeFormField)('retentionPolicyMaxAge', 'retention_policy.time.max_age', config, {
      dependsOn: ['retentionPolicyField'],
      isNullable: false,
      isOptional: true,
      isOptionalInSection: false,
      section: 'retentionPolicy',
      validator: 'retentionPolicyMaxAgeValidator'
    })
  },
  formSections: {
    retentionPolicy: (0, _form_section.initializeFormSection)('retentionPolicy', 'retention_policy', config)
  }
});
exports.getDefaultState = getDefaultState;