"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdvancedSourceEditor = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAdvancedSourceEditor = (defaults, previewRequest) => {
  const stringifiedSourceConfig = JSON.stringify(previewRequest.source.query, null, 2);

  // Advanced editor for source config state
  const [sourceConfigUpdated, setSourceConfigUpdated] = (0, _react.useState)(defaults.sourceConfigUpdated);
  const [isAdvancedSourceEditorSwitchModalVisible, setAdvancedSourceEditorSwitchModalVisible] = (0, _react.useState)(false);
  const [isAdvancedSourceEditorEnabled, setAdvancedSourceEditorEnabled] = (0, _react.useState)(defaults.isAdvancedSourceEditorEnabled);
  const [isAdvancedSourceEditorApplyButtonEnabled, setAdvancedSourceEditorApplyButtonEnabled] = (0, _react.useState)(false);
  const [advancedEditorSourceConfigLastApplied, setAdvancedEditorSourceConfigLastApplied] = (0, _react.useState)(stringifiedSourceConfig);
  const [advancedEditorSourceConfig, setAdvancedEditorSourceConfig] = (0, _react.useState)(stringifiedSourceConfig);
  const applyAdvancedSourceEditorChanges = () => {
    const sourceConfig = JSON.parse(advancedEditorSourceConfig);
    const prettySourceConfig = JSON.stringify(sourceConfig, null, 2);
    setSourceConfigUpdated(true);
    setAdvancedEditorSourceConfig(prettySourceConfig);
    setAdvancedEditorSourceConfigLastApplied(prettySourceConfig);
    setAdvancedSourceEditorApplyButtonEnabled(false);
  };

  // If switching to KQL after updating via editor - reset search
  const toggleAdvancedSourceEditor = (reset = false) => {
    if (reset === true) {
      setSourceConfigUpdated(false);
    }
    if (isAdvancedSourceEditorEnabled === false) {
      setAdvancedEditorSourceConfigLastApplied(advancedEditorSourceConfig);
    }
    setAdvancedSourceEditorEnabled(!isAdvancedSourceEditorEnabled);
    setAdvancedSourceEditorApplyButtonEnabled(false);
  };
  return {
    actions: {
      applyAdvancedSourceEditorChanges,
      setAdvancedSourceEditorApplyButtonEnabled,
      setAdvancedSourceEditorEnabled,
      setAdvancedEditorSourceConfig,
      setAdvancedEditorSourceConfigLastApplied,
      setAdvancedSourceEditorSwitchModalVisible,
      setSourceConfigUpdated,
      toggleAdvancedSourceEditor
    },
    state: {
      advancedEditorSourceConfig,
      advancedEditorSourceConfigLastApplied,
      isAdvancedSourceEditorApplyButtonEnabled,
      isAdvancedSourceEditorEnabled,
      isAdvancedSourceEditorSwitchModalVisible,
      sourceConfigUpdated
    }
  };
};
exports.useAdvancedSourceEditor = useAdvancedSourceEditor;