"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedPivotEditor = void 0;
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _put___transform__transform_id___pivot_schema = _interopRequireDefault(require("@kbn/json-schemas/src/put___transform__transform_id___pivot_schema.json"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedPivotEditor = exports.AdvancedPivotEditor = /*#__PURE__*/(0, _react.memo)(({
  actions: {
    convertToJson,
    setAdvancedEditorConfig,
    setAdvancedPivotEditorApplyButtonEnabled
  },
  state: {
    advancedEditorConfigLastApplied,
    advancedEditorConfig
  }
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorLabel', {
      defaultMessage: 'Pivot configuration object'
    }),
    "data-test-subj": "transformAdvancedPivotEditor"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 250,
    languageId: 'json',
    onChange: d => {
      setAdvancedEditorConfig(d);

      // Disable the "Apply"-Button if the config hasn't changed.
      if (advancedEditorConfigLastApplied === d) {
        setAdvancedPivotEditorApplyButtonEnabled(false);
        return;
      }

      // Try to parse the string passed on from the editor.
      // If parsing fails, the "Apply"-Button will be disabled
      try {
        JSON.parse(convertToJson(d));
        setAdvancedPivotEditorApplyButtonEnabled(true);
      } catch (e) {
        setAdvancedPivotEditorApplyButtonEnabled(false);
      }
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorAriaLabel', {
        defaultMessage: 'Advanced pivot editor'
      }),
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: advancedEditorConfig,
    editorDidMount: editor => {
      var _editor$getModel, _monaco$languages$jso;
      const editorModelUri = (_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.uri.toString();
      _monaco.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
        validate: true,
        enableSchemaRequest: false,
        schemaValidation: 'error',
        schemas: [...((_monaco$languages$jso = _monaco.monaco.languages.json.jsonDefaults.diagnosticsOptions.schemas) !== null && _monaco$languages$jso !== void 0 ? _monaco$languages$jso : []), {
          uri: editorModelUri,
          fileMatch: [editorModelUri],
          schema: _put___transform__transform_id___pivot_schema.default
        }]
      });
    }
  }));
}, (prevProps, nextProps) => (0, _lodash.isEqual)(pickProps(prevProps), pickProps(nextProps)));
function pickProps(props) {
  return [props.state.advancedEditorConfigLastApplied, props.state.advancedEditorConfig];
}