"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTransforms = void 0;
var _reactQuery = require("@kbn/react-query");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
var _transform = require("../common/transform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialData = () => ({
  transforms: [],
  transformIds: []
});
const useGetTransforms = ({
  enabled
} = {}) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  const {
    data = getInitialData(),
    ...rest
  } = (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORMS], async ({
    signal
  }) => {
    const update = getInitialData();
    const transformConfigs = await http.get((0, _constants.addInternalBasePath)('transforms'), {
      version: '1',
      asSystemRequest: true,
      signal
    });

    // There might be some errors with fetching certain transforms
    // For example, when task exists and is running but the config is deleted
    if (Array.isArray(transformConfigs.errors) && transformConfigs.errors.length > 0) {
      const danglingTaskIdMatches = transformConfigs.errors.filter(e => e.type === _transform.TRANSFORM_ERROR_TYPE.DANGLING_TASK).map(e => {
        // Getting the transform id from the ES error message
        const matches = /\[([^)]+)\]/.exec(e.reason);
        return Array.isArray(matches) && matches.length >= 1 ? matches[1] : undefined;
      }).filter(_mlIsDefined.isDefined);
      update.transformIdsWithoutConfig = danglingTaskIdMatches.length > 0 ? danglingTaskIdMatches : undefined;
    }
    update.transforms = transformConfigs.transforms.reduce((reducedtableRows, config) => {
      // Table with expandable rows requires `id` on the outermost level
      reducedtableRows.push({
        id: config.id,
        config,
        mode: typeof config.sync !== 'undefined' ? _constants.TRANSFORM_MODE.CONTINUOUS : _constants.TRANSFORM_MODE.BATCH,
        stats: undefined,
        alerting_rules: config.alerting_rules
      });
      return reducedtableRows;
    }, []);
    update.transformIds = update.transforms.map(({
      id
    }) => id);
    return update;
  }, {
    enabled,
    refetchInterval: _constants.DEFAULT_REFRESH_INTERVAL_MS
  });
  return {
    data,
    ...rest
  };
};
exports.useGetTransforms = useGetTransforms;