"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LateBindingSpanProcessor = void 0;
var _lodash = require("lodash");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const noop = async () => {};

/**
 * This processor allows consumers to register Span processors after startup,
 * which is useful if processors should be conditionally applied based on config
 * or runtime logic.
 */
var _processors = /*#__PURE__*/new WeakMap();
class LateBindingSpanProcessor {
  constructor() {
    _classPrivateFieldInitSpec(this, _processors, []);
  }
  onStart(span, parentContext) {
    _classPrivateFieldGet(_processors, this).forEach(processor => processor.onStart(span, parentContext));
  }
  onEnd(span) {
    _classPrivateFieldGet(_processors, this).forEach(processor => processor.onEnd(span));
  }
  async forceFlush() {
    await Promise.all(_classPrivateFieldGet(_processors, this).map(processor => processor.forceFlush()));
  }
  async shutdown() {
    await Promise.all(_classPrivateFieldGet(_processors, this).map(processor => processor.shutdown()));
  }
  register(processor) {
    _classPrivateFieldGet(_processors, this).push(processor);
    return async () => {
      (0, _lodash.pull)(_classPrivateFieldGet(_processors, this), processor);
      await processor.shutdown();
    };
  }
  static register(processor) {
    var _assertClassBrand$_$r, _assertClassBrand$_;
    return (_assertClassBrand$_$r = (_assertClassBrand$_ = _assertClassBrand(LateBindingSpanProcessor, this, _instance)._) === null || _assertClassBrand$_ === void 0 ? void 0 : _assertClassBrand$_.register(processor)) !== null && _assertClassBrand$_$r !== void 0 ? _assertClassBrand$_$r : noop;
  }
  static get() {
    if (!_assertClassBrand(LateBindingSpanProcessor, this, _instance)._) {
      _instance._ = _assertClassBrand(LateBindingSpanProcessor, this, new LateBindingSpanProcessor());
    }
    return _assertClassBrand(LateBindingSpanProcessor, this, _instance)._;
  }
}
exports.LateBindingSpanProcessor = LateBindingSpanProcessor;
var _instance = {
  _: void 0
};