"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectPrivateLocationsState = exports.selectPrivateLocationsLoading = exports.selectPrivateLocations = exports.selectPrivateLocationToEdit = exports.selectPrivateLocationFlyoutVisible = exports.selectPrivateLocationDeleting = exports.selectPrivateLocationCreating = exports.selectAgentPolicies = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getState = appState => appState.privateLocations;
const selectAgentPolicies = exports.selectAgentPolicies = (0, _reselect.createSelector)(getState, state => state);
const selectPrivateLocationFlyoutVisible = state => {
  var _state$privateLocatio;
  return (_state$privateLocatio = state.privateLocations.isPrivateLocationFlyoutVisible) !== null && _state$privateLocatio !== void 0 ? _state$privateLocatio : false;
};
exports.selectPrivateLocationFlyoutVisible = selectPrivateLocationFlyoutVisible;
const selectPrivateLocationToEdit = state => state.privateLocations.privateLocationToEdit;
exports.selectPrivateLocationToEdit = selectPrivateLocationToEdit;
const selectPrivateLocationsLoading = state => {
  var _state$privateLocatio2;
  return (_state$privateLocatio2 = state.privateLocations.loading) !== null && _state$privateLocatio2 !== void 0 ? _state$privateLocatio2 : false;
};
exports.selectPrivateLocationsLoading = selectPrivateLocationsLoading;
const selectPrivateLocationCreating = state => {
  var _state$privateLocatio3;
  return (_state$privateLocatio3 = state.privateLocations.createLoading) !== null && _state$privateLocatio3 !== void 0 ? _state$privateLocatio3 : false;
};
exports.selectPrivateLocationCreating = selectPrivateLocationCreating;
const selectPrivateLocationDeleting = state => {
  var _state$privateLocatio4;
  return (_state$privateLocatio4 = state.privateLocations.deleteLoading) !== null && _state$privateLocatio4 !== void 0 ? _state$privateLocatio4 : false;
};
exports.selectPrivateLocationDeleting = selectPrivateLocationDeleting;
const selectPrivateLocationsState = state => state.privateLocations;
exports.selectPrivateLocationsState = selectPrivateLocationsState;
const selectPrivateLocations = state => {
  var _state$privateLocatio5;
  return (_state$privateLocatio5 = state.privateLocations.data) !== null && _state$privateLocatio5 !== void 0 ? _state$privateLocatio5 : [];
};
exports.selectPrivateLocations = selectPrivateLocations;