"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchNetworkEventsEffect = fetchNetworkEventsEffect;
var _effects = require("redux-saga/effects");
var _api = require("./api");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchNetworkEventsEffect() {
  yield (0, _effects.takeLatest)(_actions.getNetworkEvents.get, function* (action) {
    try {
      const response = yield (0, _effects.call)(_api.fetchNetworkEvents, action.payload);
      yield (0, _effects.put)(_actions.getNetworkEvents.success({
        checkGroup: action.payload.checkGroup,
        stepIndex: action.payload.stepIndex,
        ...response
      }));
    } catch (e) {
      yield (0, _effects.put)(_actions.getNetworkEvents.fail({
        checkGroup: action.payload.checkGroup,
        stepIndex: action.payload.stepIndex,
        error: e
      }));
    }
  });
}