"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchUpsertMonitor = exports.fetchMonitorManagementList = exports.fetchMonitorFilters = exports.fetchDeleteMonitor = exports.createGettingStartedMonitor = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toMonitorManagementListQueryArgs(pageState) {
  return {
    perPage: pageState.pageSize,
    page: pageState.pageIndex + 1,
    sortOrder: pageState.sortOrder,
    sortField: pageState.sortField,
    query: pageState.query,
    tags: pageState.tags,
    locations: pageState.locations,
    monitorTypes: pageState.monitorTypes,
    projects: pageState.projects,
    schedules: pageState.schedules,
    monitorQueryIds: pageState.monitorQueryIds,
    searchFields: [],
    internal: true,
    showFromAllSpaces: pageState.showFromAllSpaces,
    useLogicalAndFor: pageState.useLogicalAndFor
  };
}
const fetchMonitorManagementList = async pageState => {
  const params = toMonitorManagementListQueryArgs(pageState);
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS, {
    ...params,
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.fetchMonitorManagementList = fetchMonitorManagementList;
const fetchDeleteMonitor = async ({
  configIds,
  spaceId
}) => {
  const baseUrl = _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS;
  return await _api_service.apiService.post(baseUrl + '/_bulk_delete', {
    ids: configIds
  }, undefined, {
    version: _constants.INITIAL_REST_VERSION,
    spaceId
  });
};
exports.fetchDeleteMonitor = fetchDeleteMonitor;
const fetchUpsertMonitor = async ({
  monitor,
  configId
}) => {
  if (configId) {
    return await _api_service.apiService.put(`${_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS}/${configId}`, monitor, null, {
      version: _constants.INITIAL_REST_VERSION,
      internal: true
    });
  } else {
    return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS, monitor, null, {
      version: _constants.INITIAL_REST_VERSION
    });
  }
};
exports.fetchUpsertMonitor = fetchUpsertMonitor;
const createGettingStartedMonitor = async ({
  monitor
}) => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS, monitor, undefined, {
    gettingStarted: true,
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.createGettingStartedMonitor = createGettingStartedMonitor;
const fetchMonitorFilters = async ({
  showFromAllSpaces = false
}) => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.FILTERS, {
    showFromAllSpaces
  });
};
exports.fetchMonitorFilters = fetchMonitorFilters;