"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableDefaultAlertingEffect = enableDefaultAlertingEffect;
exports.enableDefaultAlertingSilentlyEffect = enableDefaultAlertingSilentlyEffect;
exports.getDefaultAlertingEffect = getDefaultAlertingEffect;
exports.inspectStatusRuleEffect = inspectStatusRuleEffect;
exports.inspectTLSRuleEffect = inspectTLSRuleEffect;
exports.updateDefaultAlertingEffect = updateDefaultAlertingEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _actions = require("./actions");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* getDefaultAlertingEffect() {
  yield (0, _effects.takeLeading)(_actions.getDefaultAlertingAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.getDefaultAlertingAPI, _actions.enableDefaultAlertingAction.success, _actions.enableDefaultAlertingAction.fail, undefined, failureMessage));
}
function* enableDefaultAlertingEffect() {
  yield (0, _effects.takeLeading)(_actions.enableDefaultAlertingAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.enableDefaultAlertingAPI, _actions.enableDefaultAlertingAction.success, _actions.enableDefaultAlertingAction.fail, successMessage, failureMessage));
}
function* enableDefaultAlertingSilentlyEffect() {
  yield (0, _effects.takeLeading)(_actions.enableDefaultAlertingSilentlyAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.enableDefaultAlertingAPI, _actions.enableDefaultAlertingAction.success, _actions.enableDefaultAlertingAction.fail, undefined, failureMessage));
}
function* updateDefaultAlertingEffect() {
  yield (0, _effects.takeLeading)(_actions.updateDefaultAlertingAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.updateDefaultAlertingAPI, _actions.updateDefaultAlertingAction.success, _actions.updateDefaultAlertingAction.fail, successMessage, failureMessage));
}
function* inspectStatusRuleEffect() {
  yield (0, _effects.takeLeading)(_actions.inspectStatusRuleAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.inspectStatusAlertAPI, _actions.inspectStatusRuleAction.success, _actions.inspectStatusRuleAction.fail, '', _i18n.i18n.translate('xpack.synthetics.settings.statusRule.inspect', {
    defaultMessage: 'Failed to inspect monitor status rule type.'
  })));
}
function* inspectTLSRuleEffect() {
  yield (0, _effects.takeLeading)(_actions.inspectTLSRuleAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.inspectTLSAlertAPI, _actions.inspectTLSRuleAction.success, _actions.inspectTLSRuleAction.fail, '', _i18n.i18n.translate('xpack.synthetics.settings.TLSRule.inspect', {
    defaultMessage: 'Failed to inspect monitor TLS rule type.'
  })));
}
const successMessage = _i18n.i18n.translate('xpack.synthetics.settings.enableAlerting', {
  defaultMessage: 'Monitor status rule successfully updated. Changes will take effect on the next rule execution.'
});
const failureMessage = _i18n.i18n.translate('xpack.synthetics.settings.enabledAlert.fail', {
  defaultMessage: 'Failed to update monitor status rule type.'
});