"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _alert_defaults_form = require("./alerting_defaults/alert_defaults_form");
var _project_api_keys = require("./project_api_keys/project_api_keys");
var _params_list = require("./global_params/params_list");
var _data_retention = require("./data_retention");
var _use_settings_breadcrumbs = require("./use_settings_breadcrumbs");
var _manage_private_locations = require("./private_locations/manage_private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsPage = () => {
  (0, _use_settings_breadcrumbs.useSettingsBreadcrumbs)();
  const {
    tabId
  } = (0, _reactRouterDom.useParams)();
  const renderTab = () => {
    switch (tabId) {
      case 'api-keys':
        return /*#__PURE__*/_react.default.createElement(_project_api_keys.ProjectAPIKeys, null);
      case 'private-locations':
        return /*#__PURE__*/_react.default.createElement(_manage_private_locations.ManagePrivateLocations, null);
      case 'data-retention':
        return /*#__PURE__*/_react.default.createElement(_data_retention.DataRetentionTab, null);
      case 'params':
        return /*#__PURE__*/_react.default.createElement(_params_list.ParamsList, null);
      case 'alerting':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          hasShadow: false,
          hasBorder: true
        }, /*#__PURE__*/_react.default.createElement(_alert_defaults_form.AlertDefaultsForm, null));
      default:
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/settings/alerting"
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", null, renderTab());
};
exports.SettingsPage = SettingsPage;