"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkOperations = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _runtime_types = require("../../../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkOperations = ({
  selectedItems,
  setMonitorPendingDeletion
}) => {
  const onDeleted = () => {
    setMonitorPendingDeletion(selectedItems.map(item => item[_runtime_types.ConfigKey.CONFIG_ID]));
  };
  if (selectedItems.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsBulkOperationPopoverClickMeToLoadAContextMenuButton",
    iconType: "trash",
    iconSide: "left",
    onClick: onDeleted,
    color: "danger"
  }, _i18n.i18n.translate('xpack.synthetics.bulkOperationPopover.clickMeToLoadButtonLabel', {
    defaultMessage: 'Delete {monitorCount, number} selected {monitorCount, plural, one {monitor} other {monitors}}',
    values: {
      monitorCount: selectedItems.length
    }
  }));
};
exports.BulkOperations = BulkOperations;