"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorNotFound = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorNotFound = (error, id) => {
  var _error$body;
  const {
    packagePolicyId
  } = (0, _hooks.useGetUrlParams)();
  const updateUrlParams = (0, _hooks.useUrlParams)()[1];
  (0, _react.useEffect)(() => {
    if (id && packagePolicyId && !error) {
      updateUrlParams({
        packagePolicyId: undefined
      }, true);
    }
  }, [error, id, packagePolicyId, updateUrlParams]);
  if (!error) return null;
  return ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404;
};
exports.useMonitorNotFound = useMonitorNotFound;