"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITOR_STATUS = exports.ACTION_GROUP_DEFINITIONS = void 0;
Object.defineProperty(exports, "SYNTHETICS_RULE_TYPES", {
  enumerable: true,
  get: function () {
    return _ruleDataUtils.SYNTHETICS_RULE_TYPE_IDS;
  }
});
exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = void 0;
Object.defineProperty(exports, "SYNTHETICS_STATUS_RULE", {
  enumerable: true,
  get: function () {
    return _ruleDataUtils.SYNTHETICS_STATUS_RULE;
  }
});
Object.defineProperty(exports, "SYNTHETICS_TLS_RULE", {
  enumerable: true,
  get: function () {
    return _ruleDataUtils.SYNTHETICS_TLS_RULE;
  }
});
exports.TLS_CERTIFICATE = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_STATUS = exports.MONITOR_STATUS = {
  id: 'xpack.synthetics.alerts.actionGroups.monitorStatus',
  name: _i18n.i18n.translate('xpack.synthetics.alertRules.actionGroups.monitorStatus', {
    defaultMessage: 'Synthetics monitor status'
  })
};
const TLS_CERTIFICATE = exports.TLS_CERTIFICATE = {
  id: 'xpack.synthetics.alerts.actionGroups.tls',
  name: _i18n.i18n.translate('xpack.synthetics.alertRules.actionGroups.tls', {
    defaultMessage: 'Synthetics TLS certificate'
  })
};
const ACTION_GROUP_DEFINITIONS = exports.ACTION_GROUP_DEFINITIONS = {
  MONITOR_STATUS,
  TLS_CERTIFICATE
};
const SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = 'observability.uptime';