"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardsApi = void 0;
var _react = require("react");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("./use_kibana");
var _use_stream_detail = require("./use_stream_detail");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardsApi = name => {
  const {
    refresh
  } = (0, _use_stream_detail.useStreamDetail)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const addDashboards = (0, _react.useCallback)(async dashboards => {
    await streamsRepositoryClient.fetch('POST /api/streams/{name}/dashboards/_bulk 2023-10-31', {
      signal,
      params: {
        path: {
          name
        },
        body: {
          operations: dashboards.map(dashboard => {
            return {
              index: {
                id: dashboard.id
              }
            };
          })
        }
      }
    });
    refresh();
  }, [name, signal, streamsRepositoryClient, refresh]);
  const removeDashboards = (0, _react.useCallback)(async dashboards => {
    await streamsRepositoryClient.fetch('POST /api/streams/{name}/dashboards/_bulk 2023-10-31', {
      signal,
      params: {
        path: {
          name
        },
        body: {
          operations: dashboards.map(dashboard => {
            return {
              delete: {
                id: dashboard.id
              }
            };
          })
        }
      }
    });
    refresh();
  }, [name, signal, streamsRepositoryClient, refresh]);
  return {
    addDashboards,
    removeDashboards
  };
};
exports.useDashboardsApi = useDashboardsApi;