"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokPatternDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GrokPatternDefinition = () => {
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'pattern_definitions'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokPatternDefinitionsLabel', {
      defaultMessage: 'Pattern definitions'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokPatternDefinitionsHelpText', {
      defaultMessage: 'A map of pattern-name and pattern tuples defining custom patterns. Patterns matching existing names will override the pre-existing definition.'
    }),
    isInvalid: fieldState.invalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: (0, _helpers.serializeXJson)(field.value),
    onChange: value => field.onChange((0, _helpers.deserializeJson)(value)),
    languageId: "xjson",
    height: 200,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokPatternDefinitionsAriaLabel', {
      defaultMessage: 'Pattern definitions editor'
    })
  }));
};
exports.GrokPatternDefinition = GrokPatternDefinition;