"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedFieldMappingOptions = void 0;
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _streamsSchema = require("@kbn/streams-schema");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const label = _i18n.i18n.translate('xpack.streams.advancedFieldMappingOptions.label', {
  defaultMessage: 'Advanced field mapping parameters'
});
const AdvancedFieldMappingOptions = ({
  field,
  onChange,
  onValidate,
  isEditing
}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordionID'
  });
  const [hasParsingError, {
    on: markAsParsingError,
    off: resetParsingErrorFlag
  }] = (0, _reactHooks.useBoolean)(false);
  const isInvalid = hasParsingError || !getValidFlag(field.additionalParameters);
  const jsonOptions = (0, _react.useMemo)(() => field.additionalParameters ? JSON.stringify(field.additionalParameters, null, 2) : '', [field.additionalParameters]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: isInvalid ? _i18n.i18n.translate('xpack.streams.advancedFieldMappingOptions.error', {
      defaultMessage: 'Invalid advanced field mapping parameters. It should be defined as a JSON object.'
    }) : undefined,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.advancedFieldMappingOptions.docs.label",
      defaultMessage: "Parameters can be defined with JSON. {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAdvancedFieldMappingOptionsViewDocumentationLink",
          href: core.docLinks.links.elasticsearch.docsBase.concat('mapping-params.html'),
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.streams.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation."
        }))
      }
    })
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 120,
    languageId: "json",
    value: jsonOptions,
    onChange: value => {
      try {
        const additionalParameters = value === '' ? undefined : JSON.parse(value);
        onChange({
          additionalParameters
        });
        if (onValidate) onValidate(getValidFlag(additionalParameters));
        resetParsingErrorFlag();
      } catch (error) {
        markAsParsingError();
        if (onValidate) onValidate(false);
      }
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true
  }, jsonOptions))));
};
exports.AdvancedFieldMappingOptions = AdvancedFieldMappingOptions;
const getValidFlag = additionalParameters => {
  return Boolean(!additionalParameters || additionalParameters === '' || (0, _streamsSchema.isSchema)(_streamsSchema.recursiveRecord, additionalParameters));
};