"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadSlmStatus = exports.useLoadRetentionSettings = exports.useLoadPolicy = exports.useLoadPolicies = exports.useLoadIndices = exports.useLoadFeatures = exports.updateRetentionSchedule = exports.setUiMetricServicePolicy = exports.executeRetention = exports.executePolicy = exports.editPolicy = exports.deletePolicies = exports.addPolicy = void 0;
var _constants = require("../../../../common/constants");
var _constants2 = require("../../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary hack to provide the uiMetricService instance to this file.
// TODO: Refactor and export an ApiService instance through the app dependencies context
let uiMetricService;
const setUiMetricServicePolicy = _uiMetricService => {
  uiMetricService = _uiMetricService;
};
// End hack
exports.setUiMetricServicePolicy = setUiMetricServicePolicy;
const useLoadPolicies = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policies`,
    method: 'get'
  });
};
exports.useLoadPolicies = useLoadPolicies;
const useLoadPolicy = name => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policy/${encodeURIComponent(name)}`,
    method: 'get'
  });
};
exports.useLoadPolicy = useLoadPolicy;
const useLoadIndices = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policies/indices`,
    method: 'get'
  });
};
exports.useLoadIndices = useLoadIndices;
const useLoadFeatures = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policies/features`,
    method: 'get'
  });
};
exports.useLoadFeatures = useLoadFeatures;
const executePolicy = async name => {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policy/${encodeURIComponent(name)}/run`,
    method: 'post'
  });
  uiMetricService.trackUiMetric(_constants2.UIM_POLICY_EXECUTE);
  return result;
};
exports.executePolicy = executePolicy;
const deletePolicies = async names => {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policies/${names.map(name => encodeURIComponent(name)).join(',')}`,
    method: 'delete'
  });
  uiMetricService.trackUiMetric(names.length > 1 ? _constants2.UIM_POLICY_DELETE_MANY : _constants2.UIM_POLICY_DELETE);
  return result;
};
exports.deletePolicies = deletePolicies;
const addPolicy = async newPolicy => {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policies`,
    method: 'post',
    body: newPolicy
  });
  uiMetricService.trackUiMetric(_constants2.UIM_POLICY_CREATE);
  return result;
};
exports.addPolicy = addPolicy;
const editPolicy = async editedPolicy => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policies/${encodeURIComponent(editedPolicy.name)}`,
    method: 'put',
    body: editedPolicy
  });
  uiMetricService.trackUiMetric(_constants2.UIM_POLICY_UPDATE);
  return result;
};
exports.editPolicy = editPolicy;
const useLoadRetentionSettings = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policies/retention_settings`,
    method: 'get'
  });
};
exports.useLoadRetentionSettings = useLoadRetentionSettings;
const updateRetentionSchedule = retentionSchedule => {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policies/retention_settings`,
    method: 'put',
    body: {
      retentionSchedule
    }
  });
  uiMetricService.trackUiMetric(_constants2.UIM_RETENTION_SETTINGS_UPDATE);
  return result;
};
exports.updateRetentionSchedule = updateRetentionSchedule;
const executeRetention = async () => {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}policies/retention`,
    method: 'post'
  });
  uiMetricService.trackUiMetric(_constants2.UIM_RETENTION_EXECUTE);
  return result;
};
exports.executeRetention = executeRetention;
const useLoadSlmStatus = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}policies/slm_status`,
    method: 'get'
  });
};
exports.useLoadSlmStatus = useLoadSlmStatus;