"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListCompactView = SloListCompactView;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _i18n2 = require("../../../../../common/i18n");
var _paths = require("../../../../../common/locators/paths");
var _slo_badges = require("../../../../components/slo/slo_badges");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_badges/slo_active_alerts_badge");
var _slo_tags_badge = require("../../../../components/slo/slo_badges/slo_tags_badge");
var _action_modal = require("../../../../context/action_modal");
var _query_key_factory = require("../../../../hooks/query_key_factory");
var _use_fetch_active_alerts = require("../../../../hooks/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../../hooks/use_fetch_rules_for_slo");
var _use_get_filtered_rule_types = require("../../../../hooks/use_get_filtered_rule_types");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_permissions = require("../../../../hooks/use_permissions");
var _use_space = require("../../../../hooks/use_space");
var _chart_data_formatter = require("../../../../utils/slo/chart_data_formatter");
var _remote_slo_urls = require("../../../../utils/slo/remote_slo_urls");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _slo_remote_badge = require("../badges/slo_remote_badge");
var _slo_rules_badge = require("../badges/slo_rules_badge");
var _slo_groupings = require("../common/slo_groupings");
var _slo_list_empty = require("../slo_list_empty");
var _slo_list_error = require("../slo_list_error");
var _slo_sparkline = require("../slo_sparkline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListCompactView({
  sloList,
  loading,
  error
}) {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    uiSettings,
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = services;
  const spaceId = (0, _use_space.useSpace)();
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const sloIdsAndInstanceIds = sloList.map(slo => [slo.id, slo.instanceId]);
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const handleTagClick = tag => {
    onStateChange({
      kqlQuery: `slo.tags: "${tag}"`
    });
  };
  const [sloToAddRule, setSloToAddRule] = (0, _react.useState)(undefined);
  const handleSavedRule = () => {
    queryClient.invalidateQueries({
      queryKey: _query_key_factory.sloKeys.rules(),
      exact: false
    });
    setSloToAddRule(undefined);
  };
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloIdsAndInstanceIds.map(item => item[0])
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList
  });
  const isRemote = slo => !!slo.remote;
  const hasRemoteKibanaUrl = slo => !!slo.remote && slo.remote.kibanaUrl !== '';
  const buildActionName = actionName => slo => isRemote(slo) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionName, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    }
  })) : actionName;
  const actions = [{
    type: 'icon',
    icon: 'inspect',
    name: _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    }),
    onClick: slo => {
      var _slo$remote;
      const sloDetailsUrl = basePath.prepend(_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName));
      navigateToUrl(sloDetailsUrl);
    }
  }, {
    type: 'icon',
    icon: 'pencil',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }),
    'data-test-subj': 'sloActionsEdit',
    enabled: slo => (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const remoteEditUrl = (0, _remote_slo_urls.createRemoteSloEditUrl)(slo, spaceId);
      if (!!remoteEditUrl) {
        window.open(remoteEditUrl, '_blank');
      } else {
        navigateToUrl(basePath.prepend(_paths.paths.sloEdit(slo.id)));
      }
    }
  }, {
    type: 'icon',
    icon: 'bell',
    name: _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    }),
    'data-test-subj': 'sloActionsCreateRule',
    enabled: slo => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) && !isRemote(slo),
    onClick: slo => {
      setSloToAddRule(slo);
    }
  }, {
    type: 'icon',
    icon: 'gear',
    name: _i18n.i18n.translate('xpack.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    'data-test-subj': 'sloActionsManageRules',
    enabled: slo => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) && !isRemote(slo),
    onClick: slo => {
      const locator = locators.get(_common.rulesLocatorID);
      locator === null || locator === void 0 ? void 0 : locator.navigate({
        params: {
          sloId: slo.id
        }
      }, {
        replace: false
      });
    }
  }, {
    type: 'icon',
    icon: slo => slo.enabled ? 'stop' : 'play',
    name: slo => buildActionName(slo.enabled ? _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }) : _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }))(slo),
    description: slo => slo.enabled ? _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }) : _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }),
    'data-test-subj': 'sloActionsManage',
    enabled: slo => (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const isEnabled = slo.enabled;
      const remoteUrl = isEnabled ? (0, _remote_slo_urls.createRemoteSloDisableUrl)(slo, spaceId) : (0, _remote_slo_urls.createRemoteSloEnableUrl)(slo, spaceId);
      if (!!remoteUrl) {
        window.open(remoteUrl, '_blank');
      } else {
        triggerAction({
          item: slo,
          type: isEnabled ? 'disable' : 'enable'
        });
      }
    }
  }, {
    type: 'icon',
    icon: 'copy',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }),
    'data-test-subj': 'sloActionsClone',
    enabled: slo => (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      triggerAction({
        item: slo,
        type: 'clone'
      });
    }
  }, {
    type: 'icon',
    icon: 'trash',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }),
    'data-test-subj': 'sloActionsDelete',
    enabled: slo => (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const remoteDeleteUrl = (0, _remote_slo_urls.createRemoteSloDeleteUrl)(slo, spaceId);
      if (!!remoteDeleteUrl) {
        window.open(remoteDeleteUrl, '_blank');
      } else {
        triggerAction({
          item: slo,
          type: 'delete'
        });
      }
    }
  }, {
    type: 'icon',
    icon: 'refresh',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    }),
    'data-test-subj': 'sloActionsReset',
    enabled: slo => (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const remoteResetUrl = (0, _remote_slo_urls.createRemoteSloResetUrl)(slo, spaceId);
      if (!!remoteResetUrl) {
        window.open(remoteResetUrl, '_blank');
      } else {
        triggerAction({
          item: slo,
          type: 'reset'
        });
      }
    }
  }];
  const columns = [{
    field: 'status',
    name: 'Status',
    render: (_, slo) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_slo_badges.SloStatusBadge, {
      slo: slo
    }), /*#__PURE__*/_react.default.createElement(_slo_badges.SloStateBadge, {
      slo: slo
    }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
      slo: slo
    }))
  }, {
    field: 'alerts',
    name: 'Alerts',
    truncateText: true,
    width: '5%',
    render: (_, slo) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
      rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
      onClick: () => setSloToAddRule(slo),
      isRemote: !!slo.remote
    }), /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
      slo: slo,
      activeAlerts: activeAlertsBySlo.get(slo),
      viewMode: "compact"
    }))
  }, {
    field: 'name',
    name: 'Name',
    width: '15%',
    truncateText: {
      lines: 2
    },
    'data-test-subj': 'sloItem',
    render: (_, slo) => {
      var _slo$remote2;
      const sloDetailsUrl = basePath.prepend(_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote2 = slo.remote) === null || _slo$remote2 === void 0 ? void 0 : _slo$remote2.remoteName));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: slo.name,
        display: "block"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("a", {
        "data-test-subj": "o11ySloListItemLink",
        href: sloDetailsUrl
      }, slo.name)));
    }
  }, {
    field: 'tags',
    name: 'Tags',
    render: (_, slo) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row",
      responsive: true,
      wrap: true,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_slo_tags_badge.SloTagsBadge, {
      slo: slo,
      onClick: handleTagClick
    }))
  }, {
    field: 'instance',
    name: 'Instance',
    render: (_, slo) => {
      const groups = [slo.groupBy].flat();
      return !groups.includes(_sloSchema.ALL_VALUE) ? /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
        slo: slo,
        direction: "column",
        gutterSize: 'none'
      }) : /*#__PURE__*/_react.default.createElement("span", null, _i18n2.NOT_AVAILABLE_LABEL);
    }
  }, {
    field: 'objective',
    name: 'Objective',
    render: (_, slo) => (0, _numeral.default)(slo.objective.target).format('0.00%')
  }, {
    field: 'sli',
    name: 'SLI value',
    truncateText: true,
    render: (_, slo) => slo.summary.status === 'NO_DATA' ? _i18n2.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat)
  }, {
    field: 'historicalSli',
    name: 'Historical SLI',
    render: (_, slo) => {
      var _historicalSummaries$;
      const isSloFailed = ['VIOLATED', 'DEGRADING'].includes(slo.summary.status);
      const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)((_historicalSummaries$ = historicalSummaries.find(historicalSummary => historicalSummary.sloId === slo.id && historicalSummary.instanceId === slo.instanceId)) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data, 'sli_value');
      return /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
        chart: "line",
        id: "sli_history",
        size: "compact",
        state: isSloFailed ? 'error' : 'success',
        data: historicalSliData,
        isLoading: historicalSummaryLoading
      });
    }
  }, {
    field: 'errorBudgetRemaining',
    name: 'Budget remaining',
    truncateText: true,
    render: (_, slo) => slo.summary.status === 'NO_DATA' ? _i18n2.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.errorBudget.remaining).format(percentFormat)
  }, {
    field: 'historicalErrorBudgetRemaining',
    name: 'Historical budget remaining',
    render: (_, slo) => {
      var _historicalSummaries$2;
      const isSloFailed = ['VIOLATED', 'DEGRADING'].includes(slo.summary.status);
      const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)((_historicalSummaries$2 = historicalSummaries.find(historicalSummary => historicalSummary.sloId === slo.id && historicalSummary.instanceId === slo.instanceId)) === null || _historicalSummaries$2 === void 0 ? void 0 : _historicalSummaries$2.data, 'error_budget_remaining');
      return /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
        chart: "area",
        id: "error_budget_burn_down",
        state: isSloFailed ? 'error' : 'success',
        size: "compact",
        data: errorBudgetBurnDownData,
        isLoading: historicalSummaryLoading
      });
    }
  }, {
    name: 'Actions',
    actions,
    width: '5%'
  }];
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: sloList,
    columns: columns,
    loading: loading,
    noItemsMessage: loading ? LOADING_SLOS_LABEL : NO_SLOS_FOUND,
    tableLayout: "auto"
  }), sloToAddRule ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    consumer: _common.sloFeatureId,
    filteredRuleTypes: filteredRuleTypes,
    ruleTypeId: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    initialValues: {
      name: `${sloToAddRule.name} burn rate rule`,
      params: {
        sloId: sloToAddRule.id
      }
    },
    onSubmit: handleSavedRule,
    onCancel: () => {
      setSloToAddRule(undefined);
    },
    shouldUseRuleProducer: true
  }) : null);
}
const LOADING_SLOS_LABEL = _i18n.i18n.translate('xpack.slo.loadingSlosLabel', {
  defaultMessage: 'Loading SLOs ...'
});
const NO_SLOS_FOUND = _i18n.i18n.translate('xpack.slo.noSlosFound', {
  defaultMessage: 'No SLOs found'
});