"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _helpers = require("./helpers");
var _detail_panel_process_tab = require("../detail_panel_process_tab");
var _detail_panel_metadata_tab = require("../detail_panel_metadata_tab");
var _styles = require("./styles");
var _detail_panel_alert_tab = require("../detail_panel_alert_tab");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Detail panel in the session view.
 */
const SessionViewDetailPanel = ({
  index,
  alerts,
  alertsCount,
  isFetchingAlerts,
  hasNextPageAlerts,
  fetchNextPageAlerts,
  selectedProcess,
  investigatedAlertId,
  onJumpToEvent,
  onShowAlertDetails
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('process');
  const alertsCountStr = (0, _react.useMemo)(() => {
    return alertsCount >= _constants.ALERT_COUNT_THRESHOLD ? _constants.ALERT_COUNT_THRESHOLD + '+' : alertsCount + '';
  }, [alertsCount]);
  const tabs = (0, _react.useMemo)(() => {
    var _selectedProcess$getD, _selectedProcess$getD2, _selectedProcess$getD3, _selectedProcess$getD4;
    const hasAlerts = !!(alerts !== null && alerts !== void 0 && alerts.length);
    return [{
      id: 'process',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.process', {
        defaultMessage: 'Process'
      }),
      content: /*#__PURE__*/_react.default.createElement(_detail_panel_process_tab.DetailPanelProcessTab, {
        index: index,
        selectedProcess: selectedProcess
      })
    }, {
      id: 'metadata',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.metadata', {
        defaultMessage: 'Metadata'
      }),
      content: /*#__PURE__*/_react.default.createElement(_detail_panel_metadata_tab.DetailPanelMetadataTab, {
        processHost: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD = selectedProcess.getDetails()) === null || _selectedProcess$getD === void 0 ? void 0 : _selectedProcess$getD.host,
        processContainer: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD2 = selectedProcess.getDetails()) === null || _selectedProcess$getD2 === void 0 ? void 0 : _selectedProcess$getD2.container,
        processOrchestrator: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD3 = selectedProcess.getDetails()) === null || _selectedProcess$getD3 === void 0 ? void 0 : _selectedProcess$getD3.orchestrator,
        processCloud: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD4 = selectedProcess.getDetails()) === null || _selectedProcess$getD4 === void 0 ? void 0 : _selectedProcess$getD4.cloud
      })
    }, {
      id: 'alerts',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.alerts', {
        defaultMessage: 'Alerts'
      }),
      append: hasAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        className: "eui-alignCenter",
        size: "m"
      }, alertsCountStr),
      content: alerts && /*#__PURE__*/_react.default.createElement(_detail_panel_alert_tab.DetailPanelAlertTab, {
        alerts: alerts,
        isFetchingAlerts: isFetchingAlerts,
        hasNextPageAlerts: hasNextPageAlerts,
        fetchNextPageAlerts: fetchNextPageAlerts,
        onJumpToEvent: onJumpToEvent,
        onShowAlertDetails: onShowAlertDetails,
        investigatedAlertId: investigatedAlertId
      })
    }];
  }, [alerts, alertsCountStr, fetchNextPageAlerts, hasNextPageAlerts, isFetchingAlerts, selectedProcess, onJumpToEvent, onShowAlertDetails, investigatedAlertId, index]);
  const onSelectedTabChanged = (0, _react.useCallback)(id => {
    setSelectedTabId(id);
  }, []);
  const tabContent = (0, _react.useMemo)(() => (0, _helpers.getSelectedTabContent)(tabs, selectedTabId), [tabs, selectedTabId]);
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.detailsPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    expand: true
  }, tabs.map((tab, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: `${tab}-${i}`,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    disabled: tab.disabled,
    prepend: tab.prepend,
    append: tab.append
  }, tab.name))), tabContent);
};
exports.SessionViewDetailPanel = SessionViewDetailPanel;