"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRequest = formatRequest;
var _parse_endpoint = require("./parse_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function formatRequest(endpoint, pathParams = {}) {
  var _Object$keys, _ref, _pathname$match;
  const {
    method,
    pathname: rawPathname,
    version
  } = (0, _parse_endpoint.parseEndpoint)(endpoint);
  const optionalReg = /(\/\{\w+\?\})/g; // /{param?}

  const optionalOrRequiredParamsReg = /(\/{)((.+?))(\})/g;
  if (((_Object$keys = Object.keys(pathParams)) === null || _Object$keys === void 0 ? void 0 : _Object$keys.length) === 0) {
    const pathname = rawPathname.replace(optionalOrRequiredParamsReg, '');
    return {
      method,
      pathname,
      version
    };
  }
  const pathname = Object.keys(pathParams).reduce((acc, paramName) => {
    return acc.replace(`{${paramName}}`, encodeURIComponent(pathParams[paramName])).replace(`{${paramName}?}`, encodeURIComponent(pathParams[paramName]));
  }, rawPathname);
  if (((_ref = (_pathname$match = pathname.match(optionalReg)) !== null && _pathname$match !== void 0 ? _pathname$match : []) === null || _ref === void 0 ? void 0 : _ref.length) > 0) {
    throw new Error(`Missing parameters: ${pathname.match(optionalReg)}`);
  }
  return {
    method,
    pathname,
    version
  };
}