"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsageReportingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _https = _interopRequireDefault(require("https"));
var _serverHttpTools = require("@kbn/server-http-tools");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UsageReportingService {
  constructor(config, kibanaVersion) {
    (0, _defineProperty2.default)(this, "agent", void 0);
    this.config = config;
    this.kibanaVersion = kibanaVersion;
  }
  async reportUsage(records) {
    const reqArgs = {
      method: 'post',
      body: JSON.stringify(records),
      headers: {
        'Content-Type': 'application/json',
        'User-Agent': `Kibana/${this.kibanaVersion} node-fetch`
      }
    };
    if (this.usageApiUrl.includes('https')) {
      reqArgs.agent = this.httpAgent;
    }
    return (0, _nodeFetch.default)(this.usageApiUrl, reqArgs);
  }
  get tlsConfigs() {
    if (!this.config.tls) {
      throw new Error('usage-api TLS configs not provided');
    }
    return this.config.tls;
  }
  get usageApiUrl() {
    if (!this.config.url) {
      throw new Error('usage-api url not provided');
    }
    return `${this.config.url}${_constants.USAGE_REPORTING_ENDPOINT}`;
  }
  get httpAgent() {
    if (this.agent) {
      return this.agent;
    }
    const tlsConfig = new _serverHttpTools.SslConfig(_serverHttpTools.sslSchema.validate({
      enabled: true,
      certificate: this.tlsConfigs.certificate,
      key: this.tlsConfigs.key,
      certificateAuthorities: this.tlsConfigs.ca
    }));
    this.agent = new _https.default.Agent({
      rejectUnauthorized: tlsConfig.rejectUnauthorized,
      cert: tlsConfig.certificate,
      key: tlsConfig.key,
      ca: tlsConfig.certificateAuthorities
    });
    return this.agent;
  }
}
exports.UsageReportingService = UsageReportingService;