"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesMetricsSchema = void 0;
var _detection_rule_usage = require("./schemas/detection_rule_usage");
var _prebuilt_rule_detail = require("./schemas/prebuilt_rule_detail");
var _detection_rule_status = require("./schemas/detection_rule_status");
var _detection_rule_upgrade_status = require("./schemas/detection_rule_upgrade_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rulesMetricsSchema = exports.rulesMetricsSchema = {
  spaces_usage: {
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of spaces where detection rules added'
      }
    },
    rules_in_spaces: {
      type: 'array',
      items: {
        type: 'long',
        _meta: {
          description: 'Number of rules is each space'
        }
      }
    }
  },
  detection_rule_usage: _detection_rule_usage.ruleTypeUsageSchema,
  detection_rule_detail: {
    type: 'array',
    items: _prebuilt_rule_detail.ruleMetricsSchema
  },
  detection_rule_status: _detection_rule_status.ruleStatusMetricsSchema,
  elastic_detection_rule_upgrade_status: _detection_rule_upgrade_status.ruleUpgradeStatusSchema
};