"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAssetCriticalityQuery = exports.QUERY_SIZE = void 0;
var _build_query = require("../../../../utils/build_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildAssetCriticalityQuery = ({
  timerange,
  filterQuery,
  defaultIndex,
  pagination: {
    querySize,
    cursorStart
  } = {
    querySize: QUERY_SIZE,
    cursorStart: 0
  }
}) => {
  const filter = (0, _build_query.createQueryFilterClauses)(filterQuery);
  if (timerange) {
    filter.push({
      range: {
        '@timestamp': {
          gte: timerange.from,
          lte: timerange.to,
          format: 'strict_date_optional_time'
        }
      }
    });
  }
  const dslQuery = {
    index: defaultIndex,
    allow_no_indices: false,
    ignore_unavailable: true,
    track_total_hits: true,
    size: querySize,
    from: cursorStart,
    body: {
      query: {
        bool: {
          filter
        }
      }
    }
  };
  return dslQuery;
};
exports.buildAssetCriticalityQuery = buildAssetCriticalityQuery;
const QUERY_SIZE = exports.QUERY_SIZE = 10;