"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToEntityManagerDefinition = void 0;
var _fp = require("lodash/fp");
var _entitiesSchema = require("@kbn/entities-schema");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToEntityManagerDefinition = (description, options) => {
  const metadata = description.fields.map((0, _fp.pick)(['source', 'destination', 'aggregation']));
  const definition = {
    id: (0, _utils.buildEntityDefinitionId)(description.entityType, options.namespace),
    name: `Security '${description.entityType}' Entity Store Definition`,
    type: description.entityType,
    indexPatterns: description.indexPatterns,
    identityFields: [description.identityField],
    displayNameTemplate: `{{${description.identityField}}}`,
    metadata,
    latest: {
      timestampField: description.settings.timestampField,
      lookbackPeriod: description.settings.lookbackPeriod,
      settings: {
        syncField: description.settings.timestampField,
        syncDelay: description.settings.syncDelay,
        frequency: description.settings.frequency,
        timeout: description.settings.timeout,
        docsPerSecond: description.settings.docsPerSecond
      }
    },
    version: description.version,
    managed: true
  };
  return _entitiesSchema.entityDefinitionSchema.parse(definition);
};
exports.convertToEntityManagerDefinition = convertToEntityManagerDefinition;