"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEqlRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logEqlRequest = request => {
  const allowNoIndices = request.allow_no_indices != null ? `?allow_no_indices=${request.allow_no_indices}` : '';
  return `POST /${request.index}/_eql/search${allowNoIndices}\n${JSON.stringify(request.body, null, 2)}`;
};
exports.logEqlRequest = logEqlRequest;