"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityRuleTypeFieldMap = exports.createSecurityRuleTypeWrapper = void 0;
var _lodash = require("lodash");
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server = require("@kbn/rule-registry-plugin/server");
var _exception_lists = require("@kbn/lists-plugin/server/services/exception_lists");
var _technical_rule_field_map = require("@kbn/rule-registry-plugin/common/assets/field_maps/technical_rule_field_map");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _server2 = require("@kbn/core/server");
var _utils = require("./utils/utils");
var _constants = require("../../../../common/constants");
var _get_list_client = require("./utils/get_list_client");
var _rule_actions_legacy = require("../rule_actions_legacy");
var _schedule_notification_actions = require("../rule_actions_legacy/logic/notifications/schedule_notification_actions");
var _utils2 = require("./utils");
var _rule_monitoring = require("../../../../common/api/detection_engine/rule_monitoring");
var _rule_monitoring2 = require("../rule_monitoring");
var _signal_aad_mapping = _interopRequireDefault(require("../routes/index/signal_aad_mapping.json"));
var _saved_object_references = require("./saved_object_references");
var _with_security_span = require("../../../utils/with_security_span");
var _get_input_output_index = require("./utils/get_input_output_index");
var _constants2 = require("./constants");
var _build_timestamp_runtime_mapping = require("./utils/build_timestamp_runtime_mapping");
var _field_maps = require("../../../../common/field_maps");
var _send_alert_suppression_telemetry_event = require("./utils/telemetry/send_alert_suppression_telemetry_event");
var _send_gap_detected_telemetry_event = require("./utils/telemetry/send_gap_detected_telemetry_event");
var _apm_field_names = require("./utils/apm_field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

// eslint-disable-next-line no-restricted-imports

const aliasesFieldMap = {};
Object.entries(_signal_aad_mapping.default).forEach(([key, value]) => {
  aliasesFieldMap[key] = {
    type: 'alias',
    required: false,
    path: value
  };
});
const addApmLabelsFromParams = params => {
  _elasticApmNode.default.addLabels({
    [_apm_field_names.SECURITY_FROM]: params.from,
    [_apm_field_names.SECURITY_IMMUTABLE]: params.immutable,
    [_apm_field_names.SECURITY_MAX_SIGNALS]: params.maxSignals,
    [_apm_field_names.SECURITY_RULE_ID]: params.ruleId,
    [_apm_field_names.SECURITY_TO]: params.to
  }, false);
};
const securityRuleTypeFieldMap = exports.securityRuleTypeFieldMap = {
  ..._technical_rule_field_map.technicalRuleFieldMap,
  ..._field_maps.alertsFieldMap,
  ..._field_maps.rulesFieldMap,
  ...aliasesFieldMap
};

/* eslint-disable complexity */
const createSecurityRuleTypeWrapper = ({
  lists,
  actions,
  docLinks,
  logger,
  config,
  publicBaseUrl,
  ruleDataClient,
  ruleExecutionLoggerFactory,
  version,
  isPreview,
  isServerless,
  experimentalFeatures,
  alerting,
  analytics,
  eventsTelemetry,
  licensing,
  scheduleNotificationResponseActionsService
}) => type => {
  const {
    alertIgnoreFields: ignoreFields,
    alertMergeStrategy: mergeStrategy
  } = config;
  const persistenceRuleType = (0, _server.createPersistenceRuleTypeWrapper)({
    ruleDataClient,
    logger,
    formatAlert: _schedule_notification_actions.formatAlertForNotificationActions
  });
  return persistenceRuleType({
    ...type,
    cancelAlertsOnRuleTimeout: false,
    useSavedObjectReferences: {
      extractReferences: params => (0, _saved_object_references.extractReferences)({
        logger,
        params
      }),
      injectReferences: (params, savedObjectReferences) => (0, _saved_object_references.injectReferences)({
        logger,
        params,
        savedObjectReferences
      })
    },
    autoRecoverAlerts: false,
    getViewInAppRelativeUrl: ({
      rule,
      start,
      end
    }) => {
      var _rule$schedule, _parseScheduleDates, _parseScheduleDates2;
      let startTime = null;
      let endTime = null;
      if (start && end) {
        startTime = new Date(start).toISOString();
        endTime = new Date(end).toISOString();
      } else if ((_rule$schedule = rule.schedule) !== null && _rule$schedule !== void 0 && _rule$schedule.interval) {
        var _rule$schedule2;
        startTime = `now-${(_rule$schedule2 = rule.schedule) === null || _rule$schedule2 === void 0 ? void 0 : _rule$schedule2.interval}`;
        endTime = 'now';
      }
      if (!startTime || !endTime) {
        return '';
      }
      const fromInMs = (_parseScheduleDates = (0, _securitysolutionIoTsUtils.parseScheduleDates)(startTime)) === null || _parseScheduleDates === void 0 ? void 0 : _parseScheduleDates.format('x');
      const toInMs = (_parseScheduleDates2 = (0, _securitysolutionIoTsUtils.parseScheduleDates)(endTime)) === null || _parseScheduleDates2 === void 0 ? void 0 : _parseScheduleDates2.format('x');
      return (0, _rule_actions_legacy.getNotificationResultsLink)({
        from: fromInMs,
        to: toInMs,
        id: rule.id
      });
    },
    async executor(options) {
      _elasticApmNode.default.setTransactionName(`${options.rule.ruleTypeId} execution`);
      return (0, _with_security_span.withSecuritySpan)('securityRuleTypeExecutor', async () => {
        const {
          executionId,
          params,
          previousStartedAt,
          startedAt,
          startedAtOverridden,
          services,
          spaceId,
          state,
          rule
        } = options;
        addApmLabelsFromParams(params);
        _elasticApmNode.default.setCustomContext({
          [_apm_field_names.SECURITY_MERGE_STRATEGY]: mergeStrategy
        });
        _elasticApmNode.default.setCustomContext({
          [_apm_field_names.SECURITY_PARAMS]: params
        });
        let runState = state;
        let inputIndex = [];
        let runtimeMappings;
        const {
          from,
          maxSignals,
          timestampOverride,
          timestampOverrideFallbackDisabled,
          to
        } = params;
        const {
          savedObjectsClient,
          scopedClusterClient,
          uiSettingsClient,
          ruleMonitoringService,
          ruleResultService
        } = services;
        const searchAfterSize = Math.min(maxSignals, _constants.DEFAULT_SEARCH_AFTER_PAGE_SIZE);
        const esClient = scopedClusterClient.asCurrentUser;
        const ruleExecutionLogger = await ruleExecutionLoggerFactory({
          savedObjectsClient,
          ruleMonitoringService,
          ruleResultService,
          context: {
            executionId,
            ruleId: rule.id,
            ruleUuid: params.ruleId,
            ruleName: rule.name,
            ruleRevision: rule.revision,
            ruleType: rule.ruleTypeId,
            spaceId
          }
        });
        const completeRule = {
          ruleConfig: rule,
          ruleParams: params,
          alertId: rule.id
        };
        const {
          schedule: {
            interval
          }
        } = completeRule.ruleConfig;
        const refresh = isPreview ? false : true;
        ruleExecutionLogger.debug(`Starting Security Rule execution (interval: ${interval})`);
        await ruleExecutionLogger.logStatusChange({
          newStatus: _rule_monitoring.RuleExecutionStatusEnum.running
        });
        let result = (0, _utils2.createResultObject)(state);
        let frozenIndicesQueriedCount = 0;
        const wrapperWarnings = [];
        const wrapperErrors = [];
        const primaryTimestamp = timestampOverride !== null && timestampOverride !== void 0 ? timestampOverride : _ruleDataUtils.TIMESTAMP;
        const secondaryTimestamp = primaryTimestamp !== _ruleDataUtils.TIMESTAMP && !timestampOverrideFallbackDisabled ? _ruleDataUtils.TIMESTAMP : undefined;

        // If we have a timestampOverride, we'll compute a runtime field that emits the override for each document if it exists,
        // otherwise it emits @timestamp. If we don't have a timestamp override we don't want to pay the cost of using a
        // runtime field, so we just use @timestamp directly.
        const {
          aggregatableTimestampField,
          timestampRuntimeMappings
        } = secondaryTimestamp && timestampOverride ? {
          aggregatableTimestampField: _constants2.TIMESTAMP_RUNTIME_FIELD,
          timestampRuntimeMappings: (0, _build_timestamp_runtime_mapping.buildTimestampRuntimeMapping)({
            timestampOverride
          })
        } : {
          aggregatableTimestampField: primaryTimestamp,
          timestampRuntimeMappings: undefined
        };

        /**
         * Data Views Logic
         * Use of data views is supported for all rules other than ML and Esql.
         * Rules can define both a data view and index pattern, but on execution:
         *  - Data view is used if it is defined
         *    - Rule exits early if data view defined is not found (ie: it's been deleted)
         *  - If no data view defined, falls to using existing index logic
         * Esql rules has index in query, which can be retrieved
         */
        if ((0, _utils.isEsqlParams)(params)) {
          inputIndex = (0, _securitysolutionUtils.getIndexListFromEsqlQuery)(params.query);
        } else if (!(0, _utils.isMachineLearningParams)(params)) {
          try {
            const {
              index,
              runtimeMappings: dataViewRuntimeMappings
            } = await (0, _get_input_output_index.getInputIndex)({
              index: params.index,
              services,
              version,
              logger,
              ruleId: params.ruleId,
              dataViewId: params.dataViewId
            });
            inputIndex = index !== null && index !== void 0 ? index : [];
            runtimeMappings = dataViewRuntimeMappings;
          } catch (exc) {
            if (_server2.SavedObjectsErrorHelpers.isNotFoundError(exc)) {
              await ruleExecutionLogger.logStatusChange({
                newStatus: _rule_monitoring.RuleExecutionStatusEnum.failed,
                message: `Data View not found ${exc}`,
                userError: true
              });
            } else {
              await ruleExecutionLogger.logStatusChange({
                newStatus: _rule_monitoring.RuleExecutionStatusEnum.failed,
                message: `Check for indices to search failed ${exc}`
              });
            }
            return {
              state: result.state
            };
          }
        }

        // Make a copy of `inputIndex` or else the APM agent reports it as [Circular] for most rule types because it's the same object
        // as `index`
        _elasticApmNode.default.setCustomContext({
          [_apm_field_names.SECURITY_INPUT_INDEX]: [...inputIndex]
        });

        // check if rule has permissions to access given index pattern
        // move this collection of lines into a function in utils
        // so that we can use it in create rules route, bulk, etc.
        let skipExecution = false;
        if (!(0, _utils.isMachineLearningParams)(params)) {
          try {
            const privileges = await (0, _utils.checkPrivilegesFromEsClient)(esClient, inputIndex);
            const readIndexWarningMessage = await (0, _utils.hasReadIndexPrivileges)({
              privileges,
              ruleExecutionLogger,
              uiSettingsClient,
              docLinks
            });
            if (readIndexWarningMessage != null) {
              wrapperWarnings.push(readIndexWarningMessage);
            }
          } catch (exc) {
            wrapperWarnings.push(`Check privileges failed to execute ${exc}`);
          }
          try {
            const timestampFieldCaps = await (0, _with_security_span.withSecuritySpan)('fieldCaps', () => services.scopedClusterClient.asCurrentUser.fieldCaps({
              index: inputIndex,
              fields: secondaryTimestamp ? [primaryTimestamp, secondaryTimestamp] : [primaryTimestamp],
              include_unmapped: true,
              runtime_mappings: runtimeMappings,
              ignore_unavailable: true
            }, {
              meta: true
            }));
            const {
              foundNoIndices,
              warningMessage: warningMissingTimestampFieldsMessage
            } = await (0, _utils.hasTimestampFields)({
              timestampField: primaryTimestamp,
              timestampFieldCapsResponse: timestampFieldCaps,
              inputIndices: inputIndex,
              ruleExecutionLogger
            });
            if (warningMissingTimestampFieldsMessage != null) {
              wrapperWarnings.push(warningMissingTimestampFieldsMessage);
            }
            skipExecution = foundNoIndices;
          } catch (exc) {
            wrapperWarnings.push(`Timestamp fields check failed to execute ${exc}`);
          }
          if (!isServerless) {
            try {
              const frozenIndices = await (0, _utils.checkForFrozenIndices)({
                inputIndices: inputIndex,
                internalEsClient: services.scopedClusterClient.asInternalUser,
                currentUserEsClient: services.scopedClusterClient.asCurrentUser,
                to: params.to,
                from: params.from,
                primaryTimestamp,
                secondaryTimestamp
              });
              if (frozenIndices.length > 0) {
                frozenIndicesQueriedCount = frozenIndices.length;
              }
            } catch (exc) {
              wrapperWarnings.push(`Frozen indices check failed to execute ${exc}`);
            }
          }
        }
        const {
          tuples,
          remainingGap,
          warningStatusMessage: rangeTuplesWarningMessage,
          gap,
          originalFrom,
          originalTo
        } = await (0, _utils.getRuleRangeTuples)({
          startedAt,
          previousStartedAt,
          from,
          to,
          interval,
          maxSignals: maxSignals !== null && maxSignals !== void 0 ? maxSignals : _constants.DEFAULT_MAX_SIGNALS,
          ruleExecutionLogger,
          alerting
        });
        if (rangeTuplesWarningMessage != null) {
          wrapperWarnings.push(rangeTuplesWarningMessage);
        }
        _elasticApmNode.default.setCustomContext({
          [_apm_field_names.SECURITY_NUM_RANGE_TUPLES]: tuples.length
        });
        if (remainingGap.asMilliseconds() > 0) {
          const gapDuration = `${remainingGap.humanize()} (${remainingGap.asMilliseconds()}ms)`;
          const gapErrorMessage = `${gapDuration} were not queried between this rule execution and the last execution, so signals may have been missed. Consider increasing your look behind time or adding more Kibana instances`;
          if (analytics) {
            (0, _send_gap_detected_telemetry_event.sendGapDetectedTelemetryEvent)({
              analytics,
              interval,
              gapDuration: remainingGap,
              originalFrom,
              originalTo,
              ruleParams: params
            });
          }
          wrapperErrors.push(gapErrorMessage);
          await ruleExecutionLogger.logStatusChange({
            newStatus: _rule_monitoring.RuleExecutionStatusEnum.failed,
            message: gapErrorMessage,
            metrics: {
              executionGap: remainingGap,
              gapRange: gap
            }
          });
        }
        try {
          const {
            listClient,
            exceptionsClient
          } = (0, _get_list_client.getListClient)({
            esClient: services.scopedClusterClient.asCurrentUser,
            updatedByUser: rule.updatedBy,
            spaceId,
            lists,
            savedObjectClient: options.services.savedObjectsClient
          });
          const exceptionItems = await (0, _utils.getExceptions)({
            client: exceptionsClient,
            lists: params.exceptionsList
          });
          const alertTimestampOverride = isPreview ? startedAt : undefined;
          const legacySignalFields = Object.keys(_signal_aad_mapping.default);
          const [ignoreFieldsRegexes, ignoreFieldsStandard] = (0, _lodash.partition)([...ignoreFields, ...legacySignalFields], field => field.startsWith('/') && field.endsWith('/'));
          const ignoreFieldsObject = {};
          ignoreFieldsStandard.forEach(field => {
            ignoreFieldsObject[field] = true;
          });
          _elasticApmNode.default.setCustomContext({
            [_apm_field_names.SECURITY_NUM_IGNORE_FIELDS_STANDARD]: ignoreFieldsStandard.length,
            [_apm_field_names.SECURITY_NUM_IGNORE_FIELDS_REGEX]: ignoreFieldsRegexes.length
          });
          const intendedTimestamp = startedAtOverridden ? startedAt : undefined;
          const {
            filter: exceptionFilter,
            unprocessedExceptions
          } = await (0, _exception_lists.buildExceptionFilter)({
            startedAt,
            alias: null,
            excludeExceptions: true,
            chunkSize: 10,
            lists: exceptionItems,
            listClient
          });
          if (!skipExecution) {
            for (const tuple of tuples) {
              const runResult = await type.executor({
                ...options,
                services,
                state: runState,
                sharedParams: {
                  completeRule,
                  inputIndex,
                  exceptionFilter,
                  unprocessedExceptions,
                  runtimeMappings: {
                    ...runtimeMappings,
                    ...timestampRuntimeMappings
                  },
                  searchAfterSize,
                  tuple,
                  listClient,
                  ruleDataClient,
                  mergeStrategy,
                  primaryTimestamp,
                  secondaryTimestamp,
                  ruleExecutionLogger,
                  aggregatableTimestampField,
                  alertTimestampOverride,
                  refreshOnIndexingAlerts: refresh,
                  publicBaseUrl,
                  experimentalFeatures,
                  intendedTimestamp,
                  spaceId,
                  ignoreFields: ignoreFieldsObject,
                  ignoreFieldsRegexes,
                  eventsTelemetry,
                  licensing,
                  scheduleNotificationResponseActionsService
                }
              });
              const createdSignals = result.createdSignals.concat(runResult.createdSignals);
              const warningMessages = result.warningMessages.concat(runResult.warningMessages);
              result = {
                bulkCreateTimes: result.bulkCreateTimes.concat(runResult.bulkCreateTimes),
                enrichmentTimes: result.enrichmentTimes.concat(runResult.enrichmentTimes),
                createdSignals,
                createdSignalsCount: createdSignals.length,
                suppressedAlertsCount: runResult.suppressedAlertsCount,
                errors: result.errors.concat(runResult.errors),
                searchAfterTimes: result.searchAfterTimes.concat(runResult.searchAfterTimes),
                state: runResult.state,
                success: result.success && runResult.success,
                warning: warningMessages.length > 0,
                warningMessages,
                userError: runResult.userError,
                ...(runResult.loggedRequests ? {
                  loggedRequests: runResult.loggedRequests
                } : {})
              };
              runState = runResult.state;
            }
          } else {
            result = {
              bulkCreateTimes: [],
              enrichmentTimes: [],
              createdSignals: [],
              createdSignalsCount: 0,
              suppressedAlertsCount: 0,
              errors: [],
              searchAfterTimes: [],
              state,
              success: true,
              warning: false,
              warningMessages: []
            };
          }
          const disabledActions = rule.actions.filter(action => !actions.isActionTypeEnabled(action.actionTypeId));
          const createdSignalsCount = result.createdSignals.length;
          _elasticApmNode.default.setCustomContext({
            [_apm_field_names.SECURITY_NUM_ALERTS_CREATED]: createdSignalsCount
          });
          if (disabledActions.length > 0) {
            const disabledActionsWarning = (0, _utils.getDisabledActionsWarningText)({
              alertsCreated: createdSignalsCount > 0,
              disabledActions
            });
            wrapperWarnings.push(disabledActionsWarning);
          }
          if (result.warningMessages.length > 0 || wrapperWarnings.length > 0) {
            // write warning messages first because if we have still have an error to write
            // we want to write the error messages last, so that the errors are set
            // as the current status of the rule.
            await ruleExecutionLogger.logStatusChange({
              newStatus: _rule_monitoring.RuleExecutionStatusEnum['partial failure'],
              message: (0, _rule_monitoring2.truncateList)(result.warningMessages.concat(wrapperWarnings)).join('\n\n'),
              metrics: {
                searchDurations: result.searchAfterTimes,
                indexingDurations: result.bulkCreateTimes,
                enrichmentDurations: result.enrichmentTimes,
                frozenIndicesQueriedCount
              }
            });
          }
          if (wrapperErrors.length > 0 || result.errors.length > 0) {
            await ruleExecutionLogger.logStatusChange({
              newStatus: _rule_monitoring.RuleExecutionStatusEnum.failed,
              message: (0, _rule_monitoring2.truncateList)(result.errors.concat(wrapperErrors)).join(', '),
              metrics: {
                searchDurations: result.searchAfterTimes,
                indexingDurations: result.bulkCreateTimes,
                enrichmentDurations: result.enrichmentTimes,
                executionGap: remainingGap,
                gapRange: gap,
                frozenIndicesQueriedCount
              },
              userError: result.userError
            });
          } else if (!(result.warningMessages.length > 0) && !(wrapperWarnings.length > 0)) {
            ruleExecutionLogger.debug('Security Rule execution completed');
            ruleExecutionLogger.debug(`Finished indexing ${createdSignalsCount} alerts into ${ruleDataClient.indexNameWithNamespace(spaceId)} ${!(0, _lodash.isEmpty)(tuples) ? `searched between date ranges ${JSON.stringify(tuples, null, 2)}` : ''}`);
            await ruleExecutionLogger.logStatusChange({
              newStatus: _rule_monitoring.RuleExecutionStatusEnum.succeeded,
              message: 'Rule execution completed successfully',
              metrics: {
                searchDurations: result.searchAfterTimes,
                indexingDurations: result.bulkCreateTimes,
                enrichmentDurations: result.enrichmentTimes,
                frozenIndicesQueriedCount
              }
            });
          }
        } catch (error) {
          var _error$message;
          const errorMessage = (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : '(no error message given)';
          await ruleExecutionLogger.logStatusChange({
            newStatus: _rule_monitoring.RuleExecutionStatusEnum.failed,
            message: `An error occurred during rule execution: message: "${errorMessage}"`,
            metrics: {
              searchDurations: result.searchAfterTimes,
              indexingDurations: result.bulkCreateTimes,
              enrichmentDurations: result.enrichmentTimes,
              frozenIndicesQueriedCount
            }
          });
        }
        if (!isPreview && analytics) {
          var _result$suppressedAle;
          (0, _send_alert_suppression_telemetry_event.sendAlertSuppressionTelemetryEvent)({
            analytics,
            suppressedAlertsCount: (_result$suppressedAle = result.suppressedAlertsCount) !== null && _result$suppressedAle !== void 0 ? _result$suppressedAle : 0,
            createdAlertsCount: result.createdSignalsCount,
            ruleAttributes: rule,
            ruleParams: params
          });
        }
        return {
          state: result.state,
          ...(result.loggedRequests ? {
            loggedRequests: result.loggedRequests
          } : {})
        };
      });
    },
    alerts: {
      context: 'security',
      mappings: {
        dynamic: false,
        fieldMap: securityRuleTypeFieldMap
      },
      useEcs: true,
      useLegacyAlerts: true,
      isSpaceAware: true,
      secondaryAlias: config.signalsIndex,
      formatAlert: _schedule_notification_actions.formatAlertForNotificationActions
    }
  });
};
exports.createSecurityRuleTypeWrapper = createSecurityRuleTypeWrapper;