"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizedCommonParamsCamelToSnake = exports.commonParamsCamelToSnake = void 0;
var _snakecaseKeys = _interopRequireDefault(require("snakecase-keys"));
var _transform_actions = require("../../../../../../../common/detection_engine/transform_actions");
var _object_case_converters = require("../../../../../../utils/object_case_converters");
var _utils = require("../../../utils/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Use convertObjectKeysToSnakeCase instead
 */
const commonParamsCamelToSnake = params => {
  var _params$relatedIntegr, _params$requiredField, _params$responseActio, _params$setup;
  return {
    description: params.description,
    risk_score: params.riskScore,
    severity: params.severity,
    building_block_type: params.buildingBlockType,
    namespace: params.namespace,
    note: params.note,
    license: params.license,
    output_index: params.outputIndex,
    timeline_id: params.timelineId,
    timeline_title: params.timelineTitle,
    meta: params.meta,
    rule_name_override: params.ruleNameOverride,
    timestamp_override: params.timestampOverride,
    timestamp_override_fallback_disabled: params.timestampOverrideFallbackDisabled,
    investigation_fields: (0, _utils.migrateLegacyInvestigationFields)(params.investigationFields),
    author: params.author,
    false_positives: params.falsePositives,
    from: params.from,
    rule_id: params.ruleId,
    max_signals: params.maxSignals,
    risk_score_mapping: params.riskScoreMapping,
    severity_mapping: params.severityMapping,
    threat: params.threat,
    to: params.to,
    references: params.references,
    version: params.version,
    exceptions_list: params.exceptionsList,
    immutable: params.immutable,
    rule_source: params.ruleSource ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.ruleSource) : undefined,
    related_integrations: (_params$relatedIntegr = params.relatedIntegrations) !== null && _params$relatedIntegr !== void 0 ? _params$relatedIntegr : [],
    required_fields: (_params$requiredField = params.requiredFields) !== null && _params$requiredField !== void 0 ? _params$requiredField : [],
    response_actions: (_params$responseActio = params.responseActions) === null || _params$responseActio === void 0 ? void 0 : _params$responseActio.map(_transform_actions.transformAlertToRuleResponseAction),
    setup: (_params$setup = params.setup) !== null && _params$setup !== void 0 ? _params$setup : ''
  };
};
exports.commonParamsCamelToSnake = commonParamsCamelToSnake;
const normalizedCommonParamsCamelToSnake = params => {
  return {
    ...commonParamsCamelToSnake(params),
    rule_source: (0, _snakecaseKeys.default)(params.ruleSource, {
      deep: true
    })
  };
};
exports.normalizedCommonParamsCamelToSnake = normalizedCommonParamsCamelToSnake;