"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onboardingConfig = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _body_config = require("./components/onboarding_body/body_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onboardingConfig = exports.onboardingConfig = [{
  id: _constants.OnboardingTopicId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.default', {
    defaultMessage: 'Set up Security'
  }),
  body: _body_config.defaultBodyConfig
}, {
  id: _constants.OnboardingTopicId.siemMigrations,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.siemMigrations', {
    defaultMessage: 'SIEM rule migration'
  }),
  body: _body_config.siemMigrationsBodyConfig,
  disabledExperimentalFlagRequired: 'siemMigrationsDisabled'
}];