"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFooterStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFooterStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _css.css)`
    .footerItemTitle {
      font-weight: ${euiTheme.font.weight.semiBold};
    }
    .itemPanel {
      padding: ${euiTheme.base * 0.75}px;
    }

    .itemIconWrapper {
      display: inline-block;
      padding: ${euiTheme.size.s};
      background-color: ${euiTheme.colors.backgroundLightText};
      border-radius: ${euiTheme.border.radius.small};
    }
  `;
};
exports.useFooterStyles = useFooterStyles;