"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadRulesSectionPanel = exports.UploadRulesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var _read_more = require("../../../../../../siem_migrations/rules/components/migration_status_panels/read_more");
var _icon = require("../../../../../../siem_migrations/common/icon");
var i18n = _interopRequireWildcard(require("./translations"));
var _start_migration_card = require("./start_migration_card.styles");
var _context = require("../../../../../../siem_migrations/rules/components/data_input_flyout/context");
var _upload_rules_panel = require("./upload_rules_panel.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UploadRulesSectionPanel = exports.UploadRulesSectionPanel = /*#__PURE__*/_react.default.memo(function UploadRulesSectionPanel({
  isUploadMore = false,
  isDisabled = false,
  onOpenFlyout
}) {
  const styles = (0, _upload_rules_panel.useStyles)(isUploadMore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: isUploadMore ? 'm' : 'l'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    className: styles,
    gutterSize: isUploadMore ? 'm' : 'l'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_icon.SiemMigrationsIcon, {
    className: "siemMigrationsIcon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: _start_migration_card.TITLE_CLASS_NAME
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.START_MIGRATION_CARD_UPLOAD_MORE_TITLE)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: _start_migration_card.TITLE_CLASS_NAME
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.START_MIGRATION_CARD_UPLOAD_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.START_MIGRATION_CARD_UPLOAD_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_read_more.RuleMigrationsReadMore, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "startMigrationUploadMoreButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled
  }, i18n.START_MIGRATION_CARD_UPLOAD_MORE_BUTTON) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "startMigrationUploadRulesButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled
  }, i18n.START_MIGRATION_CARD_UPLOAD_BUTTON))));
});
const UploadRulesPanel = exports.UploadRulesPanel = /*#__PURE__*/_react.default.memo(function UploadRulesPanel({
  isUploadMore = false,
  isDisabled = false
}) {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  const {
    openFlyout
  } = (0, _context.useRuleMigrationDataInputContext)();
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout();
    telemetry.reportSetupMigrationOpen({
      isFirstMigration: !isUploadMore
    });
  }, [openFlyout, telemetry, isUploadMore]);
  return /*#__PURE__*/_react.default.createElement(UploadRulesSectionPanel, {
    isDisabled: isDisabled,
    isUploadMore: isUploadMore,
    onOpenFlyout: onOpenFlyout
  });
});
UploadRulesPanel.displayName = 'UploadRulesPanel';