"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkKpiComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _dns = require("./dns");
var _network_events = require("./network_events");
var _tls_handshakes = require("./tls_handshakes");
var _unique_flows = require("./unique_flows");
var _unique_private_ips = require("./unique_private_ips");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkKpiComponent = exports.NetworkKpiComponent = /*#__PURE__*/_react.default.memo(({
  from,
  to
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_network_events.NetworkKpiNetworkEvents, {
  from: from,
  to: to
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_dns.NetworkKpiDns, {
  from: from,
  to: to
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_unique_flows.NetworkKpiUniqueFlows, {
  from: from,
  to: to
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_tls_handshakes.NetworkKpiTlsHandshakes, {
  from: from,
  to: to
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_unique_private_ips.NetworkKpiUniquePrivateIps, {
  from: from,
  to: to
}))));
NetworkKpiComponent.displayName = 'NetworkKpiComponent';