"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateRiskEngineSettingsQuery = exports.useConfigurableRiskEngineSettings = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("../../../api/api");
var _use_configure_risk_engine_saved_object = require("../../../api/hooks/use_configure_risk_engine_saved_object");
var i18n = _interopRequireWildcard(require("../../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settingsAreEqual = (first, second) => {
  var _first$range, _second$range, _first$range2, _second$range2;
  return (first === null || first === void 0 ? void 0 : first.includeClosedAlerts) === (second === null || second === void 0 ? void 0 : second.includeClosedAlerts) && (first === null || first === void 0 ? void 0 : (_first$range = first.range) === null || _first$range === void 0 ? void 0 : _first$range.start) === (second === null || second === void 0 ? void 0 : (_second$range = second.range) === null || _second$range === void 0 ? void 0 : _second$range.start) && (first === null || first === void 0 ? void 0 : (_first$range2 = first.range) === null || _first$range2 === void 0 ? void 0 : _first$range2.end) === (second === null || second === void 0 ? void 0 : (_second$range2 = second.range) === null || _second$range2 === void 0 ? void 0 : _second$range2.end);
};
const riskEngineSettingsWithDefaults = riskEngineSettings => {
  var _riskEngineSettings$i, _riskEngineSettings$r, _riskEngineSettings$r2, _riskEngineSettings$r3, _riskEngineSettings$r4;
  return {
    includeClosedAlerts: (_riskEngineSettings$i = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : riskEngineSettings.includeClosedAlerts) !== null && _riskEngineSettings$i !== void 0 ? _riskEngineSettings$i : false,
    range: {
      start: (_riskEngineSettings$r = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : (_riskEngineSettings$r2 = riskEngineSettings.range) === null || _riskEngineSettings$r2 === void 0 ? void 0 : _riskEngineSettings$r2.start) !== null && _riskEngineSettings$r !== void 0 ? _riskEngineSettings$r : 'now-30d',
      end: (_riskEngineSettings$r3 = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : (_riskEngineSettings$r4 = riskEngineSettings.range) === null || _riskEngineSettings$r4 === void 0 ? void 0 : _riskEngineSettings$r4.end) !== null && _riskEngineSettings$r3 !== void 0 ? _riskEngineSettings$r3 : 'now'
    }
  };
};
const FETCH_RISK_ENGINE_SETTINGS = ['GET', 'FETCH_RISK_ENGINE_SETTINGS'];
const useInvalidateRiskEngineSettingsQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(async () => {
    await queryClient.invalidateQueries(FETCH_RISK_ENGINE_SETTINGS, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateRiskEngineSettingsQuery = useInvalidateRiskEngineSettingsQuery;
const useConfigurableRiskEngineSettings = () => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    fetchRiskEngineSettings
  } = (0, _api.useEntityAnalyticsRoutes)();
  const [selectedRiskEngineSettings, setSelectedRiskEngineSettings] = (0, _react.useState)(undefined);
  const invalidateRiskEngineSettingsQuery = useInvalidateRiskEngineSettingsQuery();
  const {
    data: savedRiskEngineSettings,
    isLoading: isLoadingRiskEngineSettings,
    isError
  } = (0, _reactQuery.useQuery)(FETCH_RISK_ENGINE_SETTINGS, async () => {
    const riskEngineSettings = await fetchRiskEngineSettings();
    setSelectedRiskEngineSettings(currentValue => {
      return currentValue !== null && currentValue !== void 0 ? currentValue : riskEngineSettingsWithDefaults(riskEngineSettings);
    });
    return riskEngineSettings;
  }, {
    retry: false,
    refetchOnWindowFocus: false
  });
  (0, _react.useEffect)(() => {
    // An error case, where we set the selection to default values, is a legitimate and expected part of this flow, particularly when a configuration has never been saved.
    if (isError) {
      setSelectedRiskEngineSettings(riskEngineSettingsWithDefaults());
    }
  }, [isError]);
  const resetSelectedSettings = () => {
    setSelectedRiskEngineSettings(riskEngineSettingsWithDefaults(savedRiskEngineSettings));
  };
  const {
    mutateAsync: mutateRiskEngineSettingsAsync
  } = (0, _use_configure_risk_engine_saved_object.useConfigureSORiskEngineMutation)();
  const saveSelectedSettingsMutation = (0, _reactQuery.useMutation)(async () => {
    if (selectedRiskEngineSettings) {
      await mutateRiskEngineSettingsAsync({
        includeClosedAlerts: selectedRiskEngineSettings.includeClosedAlerts,
        range: {
          start: selectedRiskEngineSettings.range.start,
          end: selectedRiskEngineSettings.range.end
        }
      }, {
        onSuccess: () => {
          addSuccess(i18n.RISK_ENGINE_SAVED_OBJECT_CONFIGURATION_SUCCESS, {
            toastLifeTimeMs: 5000
          });
        }
      });
      await invalidateRiskEngineSettingsQuery();
    }
  });
  const setSelectedDateSetting = ({
    start,
    end
  }) => {
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) return undefined;
      return {
        ...prevState,
        ...{
          range: {
            start,
            end
          }
        }
      };
    });
  };
  const toggleSelectedClosedAlertsSetting = () => {
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) return undefined;
      return {
        ...prevState,
        ...{
          includeClosedAlerts: !prevState.includeClosedAlerts
        }
      };
    });
  };
  const selectedSettingsMatchSavedSettings = settingsAreEqual(selectedRiskEngineSettings, riskEngineSettingsWithDefaults(savedRiskEngineSettings));
  return {
    savedRiskEngineSettings,
    selectedRiskEngineSettings,
    selectedSettingsMatchSavedSettings,
    resetSelectedSettings,
    setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting,
    saveSelectedSettingsMutation,
    isLoadingRiskEngineSettings
  };
};
exports.useConfigurableRiskEngineSettings = useConfigurableRiskEngineSettings;