"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreHeaderContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _severity_filter = require("../severity/severity_filter");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_information = require("../risk_information");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreHeaderContentComponent = ({
  entityLinkProps,
  onSelectSeverityFilter,
  riskEntity,
  selectedSeverity,
  toggleStatus
}) => {
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const [goToEntityRiskTab, entityRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = entityLinkProps ? getSecuritySolutionLinkProps(entityLinkProps) : {};
    return [onClick, href];
  }, [entityLinkProps, getSecuritySolutionLinkProps]);
  return toggleStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    "data-test-subj": `${riskEntity}-risk-score-header-content`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
    riskEntity: riskEntity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
    selectedItems: selectedSeverity,
    riskEntity: riskEntity,
    onSelect: onSelectSeverityFilter
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, entityRiskTabUrl && /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "data-test-subj": "view-all-button",
    onClick: goToEntityRiskTab,
    href: entityRiskTabUrl
  }, i18n.VIEW_ALL))) : null;
};
const RiskScoreHeaderContent = exports.RiskScoreHeaderContent = /*#__PURE__*/_react.default.memo(RiskScoreHeaderContentComponent);