"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreKpi = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _search_strategy = require("../../../../common/api/search_strategy");
var _search_strategy2 = require("../../../../common/search_strategy");
var _exceptions = require("../../../common/utils/exceptions");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../common/containers/use_search_strategy");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_risk_engine_status = require("./use_risk_engine_status");
var _use_risk_score_feature_status = require("./use_risk_score_feature_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskScoreKpi = ({
  filterQuery,
  skip,
  riskEntity,
  timerange
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    installed: isNewRiskScoreModuleInstalled,
    isLoading: riskScoreStatusLoading
  } = (0, _use_risk_engine_status.useIsNewRiskScoreModuleInstalled)();
  const defaultIndex = spaceId && !riskScoreStatusLoading && isNewRiskScoreModuleInstalled !== undefined ? riskEntity === _search_strategy2.EntityType.host ? (0, _search_strategy2.getHostRiskIndex)(spaceId, true, isNewRiskScoreModuleInstalled) : (0, _search_strategy2.getUserRiskIndex)(spaceId, true, isNewRiskScoreModuleInstalled) : undefined;
  const {
    isDeprecated,
    isEnabled,
    isAuthorized,
    isLoading: isDeprecatedLoading,
    refetch: refetchFeatureStatus
  } = (0, _use_risk_score_feature_status.useRiskScoreFeatureStatus)(riskEntity, defaultIndex);
  const {
    loading,
    result,
    search,
    refetch,
    inspect,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.EntityRiskQueries.kpi,
    initialResult: {
      kpiRiskScore: _search_strategy2.EMPTY_SEVERITY_COUNT
    },
    abort: skip,
    showErrorToast: false
  });
  const isModuleDisabled = !!error && (0, _exceptions.isIndexNotFoundError)(error);
  const requestTimerange = (0, _react.useMemo)(() => timerange ? {
    to: timerange.to,
    from: timerange.from,
    interval: ''
  } : undefined, [timerange]);
  (0, _react.useEffect)(() => {
    if (!skip && defaultIndex && !isDeprecatedLoading && isAuthorized && isEnabled && !isDeprecated) {
      search({
        filterQuery,
        defaultIndex: [defaultIndex],
        entity: riskEntity,
        timerange: requestTimerange
      });
    }
  }, [defaultIndex, search, filterQuery, skip, riskEntity, requestTimerange, isEnabled, isDeprecated, isAuthorized, isDeprecatedLoading]);
  const refetchAll = (0, _react.useCallback)(() => {
    if (defaultIndex) {
      refetchFeatureStatus(defaultIndex);
      refetch();
    }
  }, [defaultIndex, refetch, refetchFeatureStatus]);
  (0, _react.useEffect)(() => {
    if (error) {
      if (!(0, _exceptions.isIndexNotFoundError)(error)) {
        addError(error, {
          title: _i18n.i18n.translate('xpack.securitySolution.riskScore.kpi.failSearchDescription', {
            defaultMessage: `Failed to run search on risk score`
          })
        });
      }
    }
  }, [addError, error]);
  const severityCount = (0, _react.useMemo)(() => {
    var _result$kpiRiskScore$, _result$kpiRiskScore$2, _result$kpiRiskScore$3, _result$kpiRiskScore$4, _result$kpiRiskScore$5;
    if (loading || error) {
      return undefined;
    }
    return {
      [_search_strategy2.RiskSeverity.Unknown]: (_result$kpiRiskScore$ = result.kpiRiskScore[_search_strategy2.RiskSeverity.Unknown]) !== null && _result$kpiRiskScore$ !== void 0 ? _result$kpiRiskScore$ : 0,
      [_search_strategy2.RiskSeverity.Low]: (_result$kpiRiskScore$2 = result.kpiRiskScore[_search_strategy2.RiskSeverity.Low]) !== null && _result$kpiRiskScore$2 !== void 0 ? _result$kpiRiskScore$2 : 0,
      [_search_strategy2.RiskSeverity.Moderate]: (_result$kpiRiskScore$3 = result.kpiRiskScore[_search_strategy2.RiskSeverity.Moderate]) !== null && _result$kpiRiskScore$3 !== void 0 ? _result$kpiRiskScore$3 : 0,
      [_search_strategy2.RiskSeverity.High]: (_result$kpiRiskScore$4 = result.kpiRiskScore[_search_strategy2.RiskSeverity.High]) !== null && _result$kpiRiskScore$4 !== void 0 ? _result$kpiRiskScore$4 : 0,
      [_search_strategy2.RiskSeverity.Critical]: (_result$kpiRiskScore$5 = result.kpiRiskScore[_search_strategy2.RiskSeverity.Critical]) !== null && _result$kpiRiskScore$5 !== void 0 ? _result$kpiRiskScore$5 : 0
    };
  }, [result, loading, error]);
  return {
    error,
    severityCount,
    loading,
    isModuleDisabled,
    refetch: refetchAll,
    inspect
  };
};
exports.useRiskScoreKpi = useRiskScoreKpi;