"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubfieldHeader = SubfieldHeader;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _translations = require("../../diff_components/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SubfieldHeader({
  subfieldName
}) {
  var _fieldToDisplayNameMa;
  const subfieldLabel = (_fieldToDisplayNameMa = _translations.fieldToDisplayNameMap[subfieldName]) !== null && _fieldToDisplayNameMa !== void 0 ? _fieldToDisplayNameMa : (0, _lodash.startCase)((0, _lodash.camelCase)(subfieldName));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, subfieldLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}