"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches details for a set of ML jobs
 *
 * @param http HTTP Service
 * @param jobIds Array of job IDs to filter against
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */
const getJobs = async ({
  http,
  jobIds,
  signal
}) => http.fetch('/internal/ml/jobs/jobs', {
  method: 'POST',
  version: '1',
  body: JSON.stringify({
    jobIds
  }),
  asSystemRequest: true,
  signal
});
exports.getJobs = getJobs;