"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryPanel = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _actionable_summary = require("./actionable_summary");
var _panel_header = require("./panel_header");
var _tabs = require("./tabs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AttackDiscoveryPanelComponent = ({
  attackDiscovery,
  initialIsOpen,
  isSelected,
  setIsSelected,
  setSelectedAttackDiscoveries,
  onToggle,
  replacements,
  showAnonymized = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isOpen, setIsOpen] = (0, _react2.useState)(initialIsOpen ? 'open' : 'closed');
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `attackDiscoveryPanel-${attackDiscovery.id}`,
    hasBorder: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react2.default.createElement(_panel_header.PanelHeader, {
    attackDiscovery: attackDiscovery,
    isOpen: isOpen,
    isSelected: isSelected,
    setIsSelected: setIsSelected,
    onToggle: onToggle,
    replacements: replacements,
    setIsOpen: setIsOpen,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
    showAnonymized: showAnonymized
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_actionable_summary.ActionableSummary, {
    attackDiscovery: attackDiscovery,
    replacements: replacements,
    showAnonymized: showAnonymized
  })), isOpen === 'open' && /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    css: (0, _react.css)`
            border-top: none;
            border-radius: 0 0 6px 6px;
            margin: 0 ${euiTheme.size.m} 0 ${euiTheme.size.m};
          `,
    "data-test-subj": "attackDiscoveryTabsPanel",
    hasBorder: true
  }, /*#__PURE__*/_react2.default.createElement(_tabs.Tabs, {
    attackDiscovery: attackDiscovery,
    replacements: replacements,
    showAnonymized: showAnonymized
  })));
};
AttackDiscoveryPanelComponent.displayName = 'AttackDiscoveryPanel';
const AttackDiscoveryPanel = exports.AttackDiscoveryPanel = /*#__PURE__*/_react2.default.memo(AttackDiscoveryPanelComponent);