"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteSynonymRule = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteSynonymRule = (onSuccess, onError) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(async ({
    synonymsSetId,
    ruleId
  }) => {
    return await http.delete(`/internal/search_synonyms/synonyms/${synonymsSetId}/${ruleId}`);
  }, {
    onSuccess: (_, {
      ruleId
    }) => {
      var _notifications$toasts;
      queryClient.invalidateQueries([_constants.SYNONYMS_RULE_FETCH_QUERY_KEY]);
      queryClient.invalidateQueries([_constants.SYNONYMS_SETS_QUERY_KEY]);
      notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleSuccess', {
          defaultMessage: 'Synonym rule {ruleId} deleted',
          values: {
            ruleId
          }
        })
      });
      if (onSuccess) {
        onSuccess();
      }
    },
    onError: error => {
      if (onError) {
        onError(error.body.message);
      } else {
        var _notifications$toasts2;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts2 = notifications.toasts) === null || _notifications$toasts2 === void 0 ? void 0 : _notifications$toasts2.addError(new Error(error.body.message), {
          title: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleError', {
            defaultMessage: 'Error deleting synonym rule'
          }),
          toastMessage: error.body.message
        });
      }
    }
  });
};
exports.useDeleteSynonymRule = useDeleteSynonymRule;