"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePlaygroundBreadcrumbs = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePlaygroundBreadcrumbs = () => {
  const {
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
      text: _i18n.i18n.translate('xpack.searchPlayground.breadcrumbs.build', {
        defaultMessage: 'Build'
      })
    }, {
      text: _i18n.i18n.translate('xpack.searchPlayground.breadcrumbs.playground', {
        defaultMessage: 'Playground'
      })
    }], {
      forClassicChromeStyle: true
    });
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [searchNavigation]);
};
exports.usePlaygroundBreadcrumbs = usePlaygroundBreadcrumbs;