"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexMappings = exports.fetchIndexMappings = void 0;
var _reactQuery = require("@kbn/react-query");
var _reactHookForm = require("react-hook-form");
var _types = require("../types");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndexMappings = async ({
  indices,
  http
}) => {
  const mappings = await http.post(_types.APIRoutes.GET_INDEX_MAPPINGS, {
    body: JSON.stringify({
      indices
    })
  });
  return mappings;
};
exports.fetchIndexMappings = fetchIndexMappings;
const useIndexMappings = () => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const indices = getValues(_types.ChatFormFields.indices);
  const {
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['search-playground-index-mappings'],
    queryFn: () => fetchIndexMappings({
      indices,
      http
    }),
    refetchOnWindowFocus: false,
    refetchOnReconnect: false,
    refetchOnMount: false
  });
  return {
    data: data === null || data === void 0 ? void 0 : data.mappings
  };
};
exports.useIndexMappings = useIndexMappings;