"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchMode = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _common = require("../../../common");
var _result_list = require("./result_list");
var _types = require("../../types");
var _use_search_preview = require("../../hooks/use_search_preview");
var _pagination_helper = require("../../utils/pagination_helper");
var _use_index_mappings = require("../../hooks/use_index_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchMode = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control,
    handleSubmit
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      value: searchBarValue
    },
    formState: {
      isSubmitting
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.searchQuery
  });
  const [searchQuery, setSearchQuery] = _react.default.useState({
    query: searchBarValue,
    pagination: _common.DEFAULT_PAGINATION
  });
  const {
    results,
    pagination
  } = (0, _use_search_preview.useSearchPreview)(searchQuery);
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMappings)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const handleSearch = async (query = searchBarValue, paginationParam = _common.DEFAULT_PAGINATION) => {
    queryClient.resetQueries({
      queryKey: ['search-preview-results']
    });
    setSearchQuery({
      query,
      pagination: paginationParam
    });
  };
  const onPagination = page => {
    handleSearch(searchBarValue, (0, _pagination_helper.getPaginationFromPage)(page, pagination.size, pagination));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
          max-width: ${euiTheme.base * 48}px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSubmit(() => handleSearch())
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: _types.ChatFormFields.searchQuery,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "searchPlaygroundSearchModeFieldText"
    }, field, {
      value: searchBarValue,
      icon: "search",
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.searchMode.searchBar.placeholder', {
        defaultMessage: 'Search for documents'
      }),
      isLoading: isSubmitting
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, searchQuery.query ? /*#__PURE__*/_react.default.createElement(_result_list.ResultList, {
    searchResults: results,
    mappings: mappingData,
    pagination: pagination,
    onPaginationChange: onPagination
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: 'checkInCircleFilled',
    iconColor: "success",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.searchPlayground.searchMode.readyToSearch', {
      defaultMessage: 'Ready to search'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchPlayground.searchMode.searchPrompt', {
      defaultMessage: 'Type in a query in the search bar above or view the query we automatically created for you.'
    }))
  })))))));
};
exports.SearchMode = SearchMode;