"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeSample = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Disabled so we can track the on copy event by adding an onClick to a div
/* eslint-disable jsx-a11y/click-events-have-key-events */

const CodeSample = ({
  id,
  title,
  language,
  code,
  onCodeCopyClick,
  description
}) => {
  const onCodeClick = _react.default.useCallback(e => {
    if (onCodeCopyClick === undefined) return;
    if (e.target instanceof HTMLElement) {
      var _e$target$dataset;
      if (((_e$target$dataset = e.target.dataset) === null || _e$target$dataset === void 0 ? void 0 : _e$target$dataset.testSubj) === 'euiCodeBlockCopy') {
        onCodeCopyClick(e);
      }
    }
  }, [onCodeCopyClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    id: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, description))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    onClick: onCodeClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": `${id}-code-block`,
    language: language,
    fontSize: "m",
    paddingSize: "m",
    isCopyable: true,
    transparentBackground: true,
    css: {
      '*::selection': {
        backgroundColor: 'rgba(255, 255, 255, 0.2)'
      }
    }
  }, code)))));
};
exports.CodeSample = CodeSample;