"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnColorFnPalette = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _palette = require("./palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_COLOR_COUNT = 10;
class KbnColorFnPalette extends _palette.KbnBasePalette {
  constructor({
    type,
    colorFn,
    defaultNumberOfColors,
    colorCount = DEFAULT_COLOR_COUNT,
    ...rest
  }) {
    super({
      ...rest,
      colorCount
    });
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "_colorFn", void 0);
    (0, _defineProperty2.default)(this, "_defaultNumberOfColors", void 0);
    (0, _defineProperty2.default)(this, "colors", (n = this._defaultNumberOfColors) => {
      return this._colorFn(n === undefined ? n : Math.max(1, n));
    });
    this.type = type;
    this._colorFn = colorFn;
    this._defaultNumberOfColors = defaultNumberOfColors !== null && defaultNumberOfColors !== void 0 ? defaultNumberOfColors : colorCount;
  }
}
exports.KbnColorFnPalette = KbnColorFnPalette;