"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populateMissingSemanticTextFieldWithLock = populateMissingSemanticTextFieldWithLock;
var _lockManager = require("@kbn/lock-manager");
var _pRetry = _interopRequireDefault(require("p-retry"));
var _ = require("..");
var _inference_endpoint = require("../inference_endpoint");
var _get_inference_id_from_write_index = require("../knowledge_base_service/get_inference_id_from_write_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POPULATE_MISSING_SEMANTIC_TEXT_FIELDS_LOCK_ID = 'populate_missing_semantic_text_fields';
async function populateMissingSemanticTextFieldWithLock({
  core,
  logger,
  config,
  esClient
}) {
  const lmService = new _lockManager.LockManagerService(core, logger);
  await lmService.withLock(POPULATE_MISSING_SEMANTIC_TEXT_FIELDS_LOCK_ID, async () => populateMissingSemanticTextField({
    core,
    esClient,
    logger,
    config
  }));
}

// Ensures that every doc has populated the `semantic_text` field.
async function populateMissingSemanticTextField({
  core,
  esClient,
  logger,
  config
}) {
  logger.debug('Initalizing semantic text migration for knowledge base entries...');
  const {
    count
  } = await esClient.asInternalUser.count({
    index: _.resourceNames.writeIndexAlias.kb,
    query: {
      bool: {
        must_not: {
          exists: {
            field: 'semantic_text'
          }
        }
      }
    }
  });
  logger.info(`Documents missing 'semantic_text' before migration: ${count}`);
  if (count === 0) {
    logger.debug('No documents missing semantic_text field, skipping migration.');
    return;
  }
  await (0, _pRetry.default)(async () => {
    const inferenceId = await (0, _get_inference_id_from_write_index.getInferenceIdFromWriteIndex)(esClient);
    await (0, _inference_endpoint.waitForKbModel)({
      core,
      esClient,
      logger,
      config,
      inferenceId
    });
    await esClient.asInternalUser.updateByQuery({
      index: _.resourceNames.writeIndexAlias.kb,
      requests_per_second: 100,
      refresh: true,
      script: {
        source: `ctx._source.semantic_text = ctx._source.text`,
        lang: 'painless'
      },
      query: {
        bool: {
          filter: {
            exists: {
              field: 'text'
            }
          },
          must_not: {
            exists: {
              field: 'semantic_text'
            }
          }
        }
      }
    });
  }, {
    retries: 10,
    minTimeout: 10_000
  });
  logger.debug('Semantic text migration completed successfully.');
}