"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeFieldRangeSchema = exports.getTimeFieldRangeResponse = exports.getCardinalityOfFieldsSchema = exports.getCardinalityOfFieldsResponse = void 0;
var _configSchema = require("@kbn/config-schema");
var _runtime_mappings_schema = require("./runtime_mappings_schema");
var _datafeeds_schema = require("./datafeeds_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexPatternSchema = {
  index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())], {
    meta: {
      description: 'Index or indexes for which to return the time range.'
    }
  })
};
const querySchema = {
  query: _configSchema.schema.maybe(_configSchema.schema.any({
    meta: {
      description: 'Query to match documents in the index(es).'
    }
  }))
};
const timeFieldNameSchema = {
  timeFieldName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Name of the time field in the index'
    }
  }))
};
const getCardinalityOfFieldsSchema = exports.getCardinalityOfFieldsSchema = _configSchema.schema.object({
  ...indexPatternSchema,
  fieldNames: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'Name(s) of the field(s) to return cardinality information.'
    }
  })),
  ...querySchema,
  ...timeFieldNameSchema,
  earliestMs: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()], {
    meta: {
      description: 'Earliest timestamp for search, as epoch ms'
    }
  })),
  latestMs: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()], {
    meta: {
      description: 'Latest timestamp for search, as epoch ms'
    }
  }))
});
const getTimeFieldRangeSchema = exports.getTimeFieldRangeSchema = _configSchema.schema.object({
  ...indexPatternSchema,
  ...timeFieldNameSchema,
  ...querySchema,
  runtimeMappings: _runtime_mappings_schema.runtimeMappingsSchema,
  indicesOptions: _datafeeds_schema.indicesOptionsSchema,
  allowFutureTime: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Return times from the future'
    }
  }))
});
const getCardinalityOfFieldsResponse = () => {
  return _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number());
};
exports.getCardinalityOfFieldsResponse = getCardinalityOfFieldsResponse;
const getTimeFieldRangeResponse = () => {
  return _configSchema.schema.object({
    start: _configSchema.schema.number(),
    end: _configSchema.schema.number(),
    success: _configSchema.schema.boolean()
  });
};
exports.getTimeFieldRangeResponse = getTimeFieldRangeResponse;