"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAnomalyDetectionJobsListState = exports.JobsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _jobs_list_view = require("./components/jobs_list_view");
var _locator = require("../../../../common/constants/locator");
var _help_menu = require("../../components/help_menu");
var _kibana = require("../../contexts/kibana");
var _page_header = require("../../components/page_header");
var _header_menu_portal = require("../../components/header_menu_portal");
var _jobs_action_menu = require("../components/jobs_action_menu");
var _ml = require("../../contexts/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultAnomalyDetectionJobsListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: 'id',
  sortDirection: 'asc'
});
exports.getDefaultAnomalyDetectionJobsListState = getDefaultAnomalyDetectionJobsListState;
const JobsPage = ({
  isMlEnabledInSpace,
  lastRefresh
}) => {
  const [pageState, setPageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE, getDefaultAnomalyDetectionJobsListState());
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const helpLink = docLinks.links.ml.anomalyDetection;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.title",
    defaultMessage: "Anomaly Detection Jobs"
  })), /*#__PURE__*/_react.default.createElement(_header_menu_portal.HeaderMenuPortal, null, /*#__PURE__*/_react.default.createElement(_jobs_action_menu.JobsActionMenu, null)), /*#__PURE__*/_react.default.createElement(_jobs_list_view.JobsListView, {
    isMlEnabledInSpace: isMlEnabledInSpace,
    lastRefresh: lastRefresh,
    jobsViewState: pageState,
    onJobsViewStateUpdate: setPageState,
    showNodeInfo: showNodeInfo
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.JobsPage = JobsPage;