"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleMetricsExplorerViewRT = exports.metricsExplorerViewRT = exports.metricsExplorerViewBasicAttributesRT = exports.metricsExplorerViewAttributesRT = exports.metricsExplorerTimeOptionsRT = exports.metricsExplorerOptionsRT = exports.metricsExplorerChartOptionsRT = exports.metricExplorerViewStateRT = exports.metricExplorerOptionsRequiredRT = exports.metricExplorerOptionsOptionalRT = exports.inventorySortOptionRT = exports.MetricsExplorerYAxisMode = exports.MetricsExplorerChartType = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _color_palette = require("../color_palette");
var _metrics_explorer = require("../http_api/metrics_explorer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventorySortOptionRT = exports.inventorySortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
let MetricsExplorerChartType = exports.MetricsExplorerChartType = /*#__PURE__*/function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
  return MetricsExplorerChartType;
}({});
let MetricsExplorerYAxisMode = exports.MetricsExplorerYAxisMode = /*#__PURE__*/function (MetricsExplorerYAxisMode) {
  MetricsExplorerYAxisMode["fromZero"] = "fromZero";
  MetricsExplorerYAxisMode["auto"] = "auto";
  return MetricsExplorerYAxisMode;
}({});
const metricsExplorerChartOptionsRT = exports.metricsExplorerChartOptionsRT = rt.type({
  yAxisMode: rt.keyof(Object.fromEntries(Object.values(MetricsExplorerYAxisMode).map(v => [v, null]))),
  type: rt.keyof(Object.fromEntries(Object.values(MetricsExplorerChartType).map(v => [v, null]))),
  stack: rt.boolean
});
const metricsExplorerTimeOptionsRT = exports.metricsExplorerTimeOptionsRT = rt.type({
  from: rt.string,
  to: rt.string,
  interval: rt.string
});
const metricsExplorerOptionsMetricRT = rt.intersection([_metrics_explorer.metricsExplorerMetricRT, rt.partial({
  rate: rt.boolean,
  color: rt.keyof(Object.fromEntries(Object.values(_color_palette.Color).map(c => [c, null]))),
  label: rt.string
})]);
const metricExplorerOptionsRequiredRT = exports.metricExplorerOptionsRequiredRT = rt.type({
  aggregation: _metrics_explorer.metricsExplorerAggregationRT,
  metrics: rt.array(metricsExplorerOptionsMetricRT)
});
const metricExplorerOptionsOptionalRT = exports.metricExplorerOptionsOptionalRT = rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
});
const metricsExplorerOptionsRT = exports.metricsExplorerOptionsRT = rt.intersection([metricExplorerOptionsRequiredRT, metricExplorerOptionsOptionalRT]);
const metricExplorerViewStateRT = exports.metricExplorerViewStateRT = rt.type({
  chartOptions: metricsExplorerChartOptionsRT,
  currentTimerange: metricsExplorerTimeOptionsRT,
  options: metricsExplorerOptionsRT
});
const metricsExplorerViewBasicAttributesRT = exports.metricsExplorerViewBasicAttributesRT = rt.type({
  name: _ioTsUtils.nonEmptyStringRt
});
const metricsExplorerViewFlagsRT = rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
});
const metricsExplorerViewAttributesRT = exports.metricsExplorerViewAttributesRT = rt.intersection([metricExplorerViewStateRT, metricsExplorerViewBasicAttributesRT, metricsExplorerViewFlagsRT]);
const singleMetricsExplorerViewAttributesRT = rt.exact(rt.intersection([metricsExplorerViewBasicAttributesRT, metricsExplorerViewFlagsRT]));
const metricsExplorerViewRT = exports.metricsExplorerViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: metricsExplorerViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
const singleMetricsExplorerViewRT = exports.singleMetricsExplorerViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: singleMetricsExplorerViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));