"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryRowWrapper = void 0;
var _common = require("@kbn/kibana-react-plugin/common");
var _text_styles = require("./text_styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryRowWrapper = exports.LogEntryRowWrapper = _common.euiStyled.div.attrs(() => ({
  role: 'row'
}))`
    align-items: stretch;
    color: ${props => props.theme.eui.euiTextColor};
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    justify-content: flex-start;
    overflow: hidden;
  
    ${props => (0, _text_styles.monospaceTextStyle)(props.scale)};
    ${props => props.isHighlighted ? _text_styles.highlightedContentStyle : ''}
  
    &:hover {
      ${_text_styles.hoveredContentStyle}
    }
  `;
// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogEntryRowWrapper;