"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSearch = exports.DEFAULT_CONTEXT = void 0;
var _logs_explorer_controller = require("../../../state_machines/logs_explorer_controller");
var _hashed_cache = require("../../../../common/hashed_cache");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearch = exports.defaultSearch = {
  name: '',
  sortOrder: 'asc'
};
const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  selection: _logs_explorer_controller.DEFAULT_ALL_SELECTION,
  allSelection: _logs_explorer_controller.DEFAULT_ALL_SELECTION,
  searchCache: new _hashed_cache.HashedCache(),
  panelId: _constants.INTEGRATIONS_PANEL_ID,
  tabId: _constants.INTEGRATIONS_TAB_ID,
  search: defaultSearch,
  dataViewsFilter: {}
};