"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchContainerNameData = void 0;
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchContainerNameData = (filterQuery, widgetKey, groupBy, countBy, index, sortByCount, pageNumber) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_CONTAINER_NAME_WIDGET, widgetKey, filterQuery, groupBy, countBy, sortByCount, pageNumber];
  const query = (0, _reactQuery.useInfiniteQuery)(cachingKeys, async ({
    pageParam = 0
  }) => {
    const res = await http.get(_constants.AGGREGATE_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        query: filterQuery,
        groupBy,
        countBy,
        page: pageParam,
        index,
        sortByCount
      }
    });
    return res;
  }, {
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false,
    getNextPageParam: (lastPage, pages) => lastPage.hasNextPage ? pages.length : undefined
  });
  return query;
};
exports.useFetchContainerNameData = useFetchContainerNameData;